/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.oss;

import alluxio.AlluxioURI;
import alluxio.Configuration;
import alluxio.PropertyKey;
import alluxio.underfs.ObjectUnderFileSystem;
import alluxio.underfs.UnderFileSystemConfiguration;
import alluxio.underfs.options.OpenOptions;
import alluxio.underfs.oss.OSSInputStream;
import alluxio.underfs.oss.OSSOutputStream;
import alluxio.underfs.oss.com.aliyun.oss.ClientConfiguration;
import alluxio.underfs.oss.com.aliyun.oss.OSSClient;
import alluxio.underfs.oss.com.aliyun.oss.ServiceException;
import alluxio.underfs.oss.com.aliyun.oss.model.ListObjectsRequest;
import alluxio.underfs.oss.com.aliyun.oss.model.OSSObjectSummary;
import alluxio.underfs.oss.com.aliyun.oss.model.ObjectListing;
import alluxio.underfs.oss.com.aliyun.oss.model.ObjectMetadata;
import alluxio.util.UnderFileSystemUtils;
import alluxio.util.io.PathUtils;
import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class OSSUnderFileSystem
extends ObjectUnderFileSystem {
    private static final Logger LOG = LoggerFactory.getLogger(OSSUnderFileSystem.class);
    private static final String FOLDER_SUFFIX = "_$folder$";
    private final OSSClient mClient;
    private final String mBucketName;

    public static OSSUnderFileSystem createInstance(AlluxioURI uri, UnderFileSystemConfiguration conf) throws Exception {
        String bucketName = UnderFileSystemUtils.getBucketName((AlluxioURI)uri);
        Preconditions.checkArgument((boolean)conf.containsKey(PropertyKey.OSS_ACCESS_KEY), (Object)("Property " + PropertyKey.OSS_ACCESS_KEY + " is required to connect to OSS"));
        Preconditions.checkArgument((boolean)conf.containsKey(PropertyKey.OSS_SECRET_KEY), (Object)("Property " + PropertyKey.OSS_SECRET_KEY + " is required to connect to OSS"));
        Preconditions.checkArgument((boolean)conf.containsKey(PropertyKey.OSS_ENDPOINT_KEY), (Object)("Property " + PropertyKey.OSS_ENDPOINT_KEY + " is required to connect to OSS"));
        String accessId = conf.getValue(PropertyKey.OSS_ACCESS_KEY);
        String accessKey = conf.getValue(PropertyKey.OSS_SECRET_KEY);
        String endPoint = conf.getValue(PropertyKey.OSS_ENDPOINT_KEY);
        ClientConfiguration ossClientConf = OSSUnderFileSystem.initializeOSSClientConfig();
        OSSClient ossClient = new OSSClient(endPoint, accessId, accessKey, ossClientConf);
        return new OSSUnderFileSystem(uri, ossClient, bucketName, conf);
    }

    protected OSSUnderFileSystem(AlluxioURI uri, OSSClient ossClient, String bucketName, UnderFileSystemConfiguration conf) {
        super(uri, conf);
        this.mClient = ossClient;
        this.mBucketName = bucketName;
    }

    public String getUnderFSType() {
        return "oss";
    }

    public void setOwner(String path, String user, String group) {
    }

    public void setMode(String path, short mode) throws IOException {
    }

    protected boolean copyObject(String src, String dst) {
        try {
            LOG.info("Copying {} to {}", (Object)src, (Object)dst);
            this.mClient.copyObject(this.mBucketName, src, this.mBucketName, dst);
            return true;
        }
        catch (ServiceException e) {
            LOG.error("Failed to rename file {} to {}", new Object[]{src, dst, e});
            return false;
        }
    }

    protected boolean createEmptyObject(String key) {
        try {
            ObjectMetadata objMeta = new ObjectMetadata();
            objMeta.setContentLength(0L);
            this.mClient.putObject(this.mBucketName, key, new ByteArrayInputStream(new byte[0]), objMeta);
            return true;
        }
        catch (ServiceException e) {
            LOG.error("Failed to create object: {}", (Object)key, (Object)e);
            return false;
        }
    }

    protected OutputStream createObject(String key) throws IOException {
        return new OSSOutputStream(this.mBucketName, key, this.mClient);
    }

    protected boolean deleteObject(String key) {
        try {
            this.mClient.deleteObject(this.mBucketName, key);
        }
        catch (ServiceException e) {
            LOG.error("Failed to delete {}", (Object)key, (Object)e);
            return false;
        }
        return true;
    }

    protected String getFolderSuffix() {
        return FOLDER_SUFFIX;
    }

    protected ObjectUnderFileSystem.ObjectListingChunk getObjectListingChunk(String key, boolean recursive) throws IOException {
        String delimiter = recursive ? "" : PATH_SEPARATOR;
        key = PathUtils.normalizePath((String)key, (String)PATH_SEPARATOR);
        key = key.equals(PATH_SEPARATOR) ? "" : key;
        ListObjectsRequest request = new ListObjectsRequest(this.mBucketName);
        request.setPrefix(key);
        request.setMaxKeys(this.getListingChunkLength());
        request.setDelimiter(delimiter);
        ObjectListing result = this.getObjectListingChunk(request);
        if (result != null) {
            return new OSSObjectListingChunk(request, result);
        }
        return null;
    }

    private ObjectListing getObjectListingChunk(ListObjectsRequest request) {
        ObjectListing result;
        try {
            result = this.mClient.listObjects(request);
        }
        catch (ServiceException e) {
            LOG.error("Failed to list path {}", (Object)request.getPrefix(), (Object)e);
            result = null;
        }
        return result;
    }

    protected ObjectUnderFileSystem.ObjectStatus getObjectStatus(String key) {
        try {
            ObjectMetadata meta = this.mClient.getObjectMetadata(this.mBucketName, key);
            if (meta == null) {
                return null;
            }
            return new ObjectUnderFileSystem.ObjectStatus((ObjectUnderFileSystem)this, key, meta.getContentLength(), meta.getLastModified().getTime());
        }
        catch (ServiceException e) {
            LOG.warn("Failed to get Object {}, return null", (Object)key, (Object)e);
            return null;
        }
    }

    protected ObjectUnderFileSystem.ObjectPermissions getPermissions() {
        return new ObjectUnderFileSystem.ObjectPermissions((ObjectUnderFileSystem)this, "", "", 511);
    }

    protected String getRootKey() {
        return "oss://" + this.mBucketName;
    }

    private static ClientConfiguration initializeOSSClientConfig() {
        ClientConfiguration ossClientConf = new ClientConfiguration();
        ossClientConf.setConnectionTimeout(Configuration.getInt((PropertyKey)PropertyKey.UNDERFS_OSS_CONNECT_TIMEOUT));
        ossClientConf.setSocketTimeout(Configuration.getInt((PropertyKey)PropertyKey.UNDERFS_OSS_SOCKET_TIMEOUT));
        ossClientConf.setConnectionTTL(Configuration.getLong((PropertyKey)PropertyKey.UNDERFS_OSS_CONNECT_TTL));
        ossClientConf.setMaxConnections(Configuration.getInt((PropertyKey)PropertyKey.UNDERFS_OSS_CONNECT_MAX));
        return ossClientConf;
    }

    protected InputStream openObject(String key, OpenOptions options) throws IOException {
        try {
            return new OSSInputStream(this.mBucketName, key, this.mClient, options.getOffset());
        }
        catch (ServiceException e) {
            throw new IOException(e.getMessage());
        }
    }

    private final class OSSObjectListingChunk
    implements ObjectUnderFileSystem.ObjectListingChunk {
        final ListObjectsRequest mRequest;
        final ObjectListing mResult;

        OSSObjectListingChunk(ListObjectsRequest request, ObjectListing result) throws IOException {
            this.mRequest = request;
            this.mResult = result;
            if (this.mResult == null) {
                throw new IOException("OSS listing result is null");
            }
        }

        public ObjectUnderFileSystem.ObjectStatus[] getObjectStatuses() {
            List<OSSObjectSummary> objects = this.mResult.getObjectSummaries();
            ObjectUnderFileSystem.ObjectStatus[] ret = new ObjectUnderFileSystem.ObjectStatus[objects.size()];
            int i = 0;
            for (OSSObjectSummary obj : objects) {
                ret[i++] = new ObjectUnderFileSystem.ObjectStatus((ObjectUnderFileSystem)OSSUnderFileSystem.this, obj.getKey(), obj.getSize(), obj.getLastModified().getTime());
            }
            return ret;
        }

        public String[] getCommonPrefixes() {
            List<String> res = this.mResult.getCommonPrefixes();
            return res.toArray(new String[res.size()]);
        }

        public ObjectUnderFileSystem.ObjectListingChunk getNextChunk() throws IOException {
            ObjectListing nextResult;
            if (this.mResult.isTruncated() && (nextResult = OSSUnderFileSystem.this.mClient.listObjects(this.mRequest)) != null) {
                return new OSSObjectListingChunk(this.mRequest, nextResult);
            }
            return null;
        }
    }
}

