/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.oss.com.aliyun.oss.common.comm;

import alluxio.underfs.oss.com.aliyun.oss.ClientConfiguration;
import alluxio.underfs.oss.com.aliyun.oss.common.comm.IdleConnectionReaper;
import alluxio.underfs.oss.org.apache.http.HttpHost;
import alluxio.underfs.oss.org.apache.http.auth.AuthScope;
import alluxio.underfs.oss.org.apache.http.auth.NTCredentials;
import alluxio.underfs.oss.org.apache.http.client.HttpClient;
import alluxio.underfs.oss.org.apache.http.conn.scheme.Scheme;
import alluxio.underfs.oss.org.apache.http.conn.ssl.SSLSocketFactory;
import alluxio.underfs.oss.org.apache.http.impl.client.DefaultHttpClient;
import alluxio.underfs.oss.org.apache.http.impl.conn.PoolingClientConnectionManager;
import alluxio.underfs.oss.org.apache.http.impl.conn.SchemeRegistryFactory;
import alluxio.underfs.oss.org.apache.http.params.BasicHttpParams;
import alluxio.underfs.oss.org.apache.http.params.HttpConnectionParams;
import alluxio.underfs.oss.org.apache.http.params.HttpParams;
import alluxio.underfs.oss.org.apache.http.params.HttpProtocolParams;
import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

class HttpClientFactory {
    HttpClientFactory() {
    }

    public HttpClient createHttpClient(ClientConfiguration config) {
        BasicHttpParams httpClientParams = new BasicHttpParams();
        HttpProtocolParams.setUserAgent(httpClientParams, config.getUserAgent());
        HttpConnectionParams.setConnectionTimeout(httpClientParams, config.getConnectionTimeout());
        HttpConnectionParams.setSoTimeout(httpClientParams, config.getSocketTimeout());
        HttpConnectionParams.setStaleCheckingEnabled(httpClientParams, true);
        HttpConnectionParams.setTcpNoDelay(httpClientParams, true);
        PoolingClientConnectionManager connManager = HttpClientFactory.createConnectionManager(config, httpClientParams);
        DefaultHttpClient httpClient = new DefaultHttpClient(connManager, httpClientParams);
        if (System.getProperty("alluxio.underfs.oss.com.aliyun.oss.disableCertChecking") != null) {
            Scheme sch = new Scheme("https", 443, HttpClientFactory.getSSLSocketFactory());
            httpClient.getConnectionManager().getSchemeRegistry().register(sch);
        }
        String proxyHost = config.getProxyHost();
        int proxyPort = config.getProxyPort();
        if (proxyHost != null && proxyPort > 0) {
            HttpHost proxy = new HttpHost(proxyHost, proxyPort);
            httpClient.getParams().setParameter("http.route.default-proxy", proxy);
            String proxyUsername = config.getProxyUsername();
            String proxyPassword = config.getProxyPassword();
            if (proxyUsername != null && proxyPassword != null) {
                String proxyDomain = config.getProxyDomain();
                String proxyWorkstation = config.getProxyWorkstation();
                httpClient.getCredentialsProvider().setCredentials(new AuthScope(proxyHost, proxyPort), new NTCredentials(proxyUsername, proxyPassword, proxyWorkstation, proxyDomain));
            }
        }
        return httpClient;
    }

    public static PoolingClientConnectionManager createConnectionManager(ClientConfiguration config, HttpParams httpClientParams) {
        PoolingClientConnectionManager connectionManager = new PoolingClientConnectionManager(SchemeRegistryFactory.createDefault(), config.getConnectionTTL(), TimeUnit.MILLISECONDS);
        connectionManager.setDefaultMaxPerRoute(config.getMaxConnections());
        connectionManager.setMaxTotal(config.getMaxConnections());
        if (config.isUseReaper()) {
            IdleConnectionReaper.registerConnectionManager(connectionManager);
        }
        return connectionManager;
    }

    private static SSLSocketFactory getSSLSocketFactory() {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        try {
            SSLContext sslcontext = SSLContext.getInstance("SSL");
            sslcontext.init(null, trustAllCerts, null);
            SSLSocketFactory ssf = new SSLSocketFactory(sslcontext, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            return ssf;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

