/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.oss.org.apache.http.message;

import alluxio.underfs.oss.org.apache.http.Header;
import alluxio.underfs.oss.org.apache.http.HeaderElement;
import alluxio.underfs.oss.org.apache.http.ParseException;
import alluxio.underfs.oss.org.apache.http.annotation.Contract;
import alluxio.underfs.oss.org.apache.http.annotation.ThreadingBehavior;
import alluxio.underfs.oss.org.apache.http.message.BasicHeaderValueParser;
import alluxio.underfs.oss.org.apache.http.message.BasicLineFormatter;
import alluxio.underfs.oss.org.apache.http.util.Args;
import java.io.Serializable;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class BasicHeader
implements Header,
Cloneable,
Serializable {
    private static final long serialVersionUID = -5427236326487562174L;
    private final String name;
    private final String value;

    public BasicHeader(String name, String value) {
        this.name = Args.notNull(name, "Name");
        this.value = value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return BasicLineFormatter.INSTANCE.formatHeader(null, this).toString();
    }

    @Override
    public HeaderElement[] getElements() throws ParseException {
        if (this.value != null) {
            return BasicHeaderValueParser.parseElements(this.value, null);
        }
        return new HeaderElement[0];
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

