/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.oss.org.apache.http.protocol;

import alluxio.underfs.oss.org.apache.http.HttpEntityEnclosingRequest;
import alluxio.underfs.oss.org.apache.http.HttpException;
import alluxio.underfs.oss.org.apache.http.HttpRequest;
import alluxio.underfs.oss.org.apache.http.HttpRequestInterceptor;
import alluxio.underfs.oss.org.apache.http.annotation.Contract;
import alluxio.underfs.oss.org.apache.http.annotation.ThreadingBehavior;
import alluxio.underfs.oss.org.apache.http.protocol.HttpContext;
import alluxio.underfs.oss.org.apache.http.protocol.HttpDateGenerator;
import alluxio.underfs.oss.org.apache.http.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.SAFE)
public class RequestDate
implements HttpRequestInterceptor {
    private static final HttpDateGenerator DATE_GENERATOR = new HttpDateGenerator();

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (request instanceof HttpEntityEnclosingRequest && !request.containsHeader("Date")) {
            String httpdate = DATE_GENERATOR.getCurrentDate();
            request.setHeader("Date", httpdate);
        }
    }
}

