/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.oss.com.aliyun.oss.common.utils;

import alluxio.underfs.oss.com.aliyun.oss.ClientException;
import alluxio.underfs.oss.com.aliyun.oss.OSSException;
import alluxio.underfs.oss.com.aliyun.oss.internal.OSSUtils;
import alluxio.underfs.oss.com.aliyun.oss.internal.model.OSSErrorResult;
import alluxio.underfs.oss.org.apache.http.client.ClientProtocolException;
import alluxio.underfs.oss.org.apache.http.client.NonRepeatableRequestException;
import alluxio.underfs.oss.org.apache.http.conn.ConnectTimeoutException;
import alluxio.underfs.oss.org.apache.http.conn.HttpHostConnectException;
import java.io.IOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;

public class ExceptionFactory {
    public static ClientException createNetworkException(IOException ex) {
        Throwable cause;
        String requestId = "Unknown";
        String errorCode = "Unknown";
        if (ex instanceof SocketTimeoutException) {
            errorCode = "SocketTimeout";
        } else if (ex instanceof SocketException) {
            errorCode = "SocketException";
        } else if (ex instanceof ConnectTimeoutException) {
            errorCode = "ConnectionTimeout";
        } else if (ex instanceof UnknownHostException) {
            errorCode = "UnknownHost";
        } else if (ex instanceof HttpHostConnectException) {
            errorCode = "ConnectionRefused";
        } else if (ex instanceof ClientProtocolException && (cause = ex.getCause()) instanceof NonRepeatableRequestException) {
            errorCode = "NonRepeatableRequest";
            return new ClientException(cause.getMessage(), errorCode, requestId, cause);
        }
        return new ClientException(ex.getMessage(), errorCode, requestId, ex);
    }

    public static OSSException createInvalidResponseException(String requestId, Throwable cause) {
        return ExceptionFactory.createInvalidResponseException(requestId, OSSUtils.COMMON_RESOURCE_MANAGER.getFormattedString("FailedToParseResponse", cause.getMessage()));
    }

    public static OSSException createInvalidResponseException(String requestId, String rawResponseError, Throwable cause) {
        return ExceptionFactory.createInvalidResponseException(requestId, OSSUtils.COMMON_RESOURCE_MANAGER.getFormattedString("FailedToParseResponse", cause.getMessage()), rawResponseError);
    }

    public static OSSException createInvalidResponseException(String requestId, String message) {
        return ExceptionFactory.createOSSException(requestId, "InvalidResponse", message);
    }

    public static OSSException createInvalidResponseException(String requestId, String message, String rawResponseError) {
        return ExceptionFactory.createOSSException(requestId, "InvalidResponse", message, rawResponseError);
    }

    public static OSSException createOSSException(OSSErrorResult errorResult) {
        return ExceptionFactory.createOSSException(errorResult, null);
    }

    public static OSSException createOSSException(OSSErrorResult errorResult, String rawResponseError) {
        return new OSSException(errorResult.Message, errorResult.Code, errorResult.RequestId, errorResult.HostId, errorResult.Header, errorResult.ResourceType, errorResult.Method, rawResponseError);
    }

    public static OSSException createOSSException(String requestId, String errorCode, String message) {
        return new OSSException(message, errorCode, requestId, null, null, null, null);
    }

    public static OSSException createOSSException(String requestId, String errorCode, String message, String rawResponseError) {
        return new OSSException(message, errorCode, requestId, null, null, null, null, rawResponseError);
    }
}

