/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.oss.com.aliyun.oss.internal;

import alluxio.underfs.oss.com.aliyun.oss.ClientException;
import alluxio.underfs.oss.com.aliyun.oss.HttpMethod;
import alluxio.underfs.oss.com.aliyun.oss.OSSException;
import alluxio.underfs.oss.com.aliyun.oss.common.auth.CredentialsProvider;
import alluxio.underfs.oss.com.aliyun.oss.common.comm.RequestMessage;
import alluxio.underfs.oss.com.aliyun.oss.common.comm.ServiceClient;
import alluxio.underfs.oss.com.aliyun.oss.common.parser.RequestMarshallers;
import alluxio.underfs.oss.com.aliyun.oss.common.utils.CodingUtils;
import alluxio.underfs.oss.com.aliyun.oss.internal.OSSOperation;
import alluxio.underfs.oss.com.aliyun.oss.internal.OSSRequestMessageBuilder;
import alluxio.underfs.oss.com.aliyun.oss.internal.OSSUtils;
import alluxio.underfs.oss.com.aliyun.oss.internal.ResponseParsers;
import alluxio.underfs.oss.com.aliyun.oss.model.AccessControlList;
import alluxio.underfs.oss.com.aliyun.oss.model.Bucket;
import alluxio.underfs.oss.com.aliyun.oss.model.BucketList;
import alluxio.underfs.oss.com.aliyun.oss.model.BucketLoggingResult;
import alluxio.underfs.oss.com.aliyun.oss.model.BucketReferer;
import alluxio.underfs.oss.com.aliyun.oss.model.BucketWebsiteResult;
import alluxio.underfs.oss.com.aliyun.oss.model.CannedAccessControlList;
import alluxio.underfs.oss.com.aliyun.oss.model.CreateBucketRequest;
import alluxio.underfs.oss.com.aliyun.oss.model.LifecycleRule;
import alluxio.underfs.oss.com.aliyun.oss.model.ListBucketsRequest;
import alluxio.underfs.oss.com.aliyun.oss.model.ListObjectsRequest;
import alluxio.underfs.oss.com.aliyun.oss.model.ObjectListing;
import alluxio.underfs.oss.com.aliyun.oss.model.SetBucketLifecycleRequest;
import alluxio.underfs.oss.com.aliyun.oss.model.SetBucketLoggingRequest;
import alluxio.underfs.oss.com.aliyun.oss.model.SetBucketWebsiteRequest;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class OSSBucketOperation
extends OSSOperation {
    public OSSBucketOperation(ServiceClient client, CredentialsProvider credsProvider) {
        super(client, credsProvider);
    }

    public Bucket createBucket(CreateBucketRequest createBucketRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(createBucketRequest, "createBucketRequest");
        String bucketName = createBucketRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> headers = new HashMap<String, String>();
        OSSBucketOperation.addOptionalACLHeader(headers, createBucketRequest.getCannedACL());
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.PUT).setBucket(bucketName).setHeaders(headers).setInputStreamWithLength(RequestMarshallers.createBucketRequestMarshaller.marshall(createBucketRequest)).build();
        this.doOperation(request, emptyResponseParser, bucketName, null);
        return new Bucket(bucketName);
    }

    public void deleteBucket(String bucketName) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.DELETE).setBucket(bucketName).build();
        this.doOperation(request, emptyResponseParser, bucketName, null);
    }

    public List<Bucket> listBuckets() throws OSSException, ClientException {
        BucketList bucketList = this.listBuckets(new ListBucketsRequest(null, null, null));
        List<Bucket> buckets = bucketList.getBucketList();
        while (bucketList.isTruncated()) {
            bucketList = this.listBuckets(new ListBucketsRequest(null, bucketList.getNextMarker(), null));
            buckets.addAll(bucketList.getBucketList());
        }
        return buckets;
    }

    public BucketList listBuckets(ListBucketsRequest listBucketRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(listBucketRequest, "listBucketRequest");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        if (listBucketRequest.getPrefix() != null) {
            params.put("prefix", listBucketRequest.getPrefix());
        }
        if (listBucketRequest.getMarker() != null) {
            params.put("marker", listBucketRequest.getMarker());
        }
        if (listBucketRequest.getMaxKeys() != null) {
            params.put("max-keys", Integer.toString(listBucketRequest.getMaxKeys()));
        }
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setParameters(params).build();
        return this.doOperation(request, ResponseParsers.listBucketResponseParser, null, null, true);
    }

    public void setBucketAcl(String bucketName, CannedAccessControlList cannedAcl) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> headers = new HashMap<String, String>();
        OSSBucketOperation.addOptionalACLHeader(headers, cannedAcl);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.PUT).setBucket(bucketName).setHeaders(headers).build();
        this.doOperation(request, emptyResponseParser, bucketName, null);
    }

    public AccessControlList getBucketAcl(String bucketName) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("acl", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(params).build();
        return this.doOperation(request, ResponseParsers.getBucketAclResponseParser, bucketName, null, true);
    }

    public void setBucketReferer(String bucketName, BucketReferer referer) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        if (referer == null) {
            referer = new BucketReferer();
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("referer", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.PUT).setBucket(bucketName).setParameters(params).setInputStreamWithLength(RequestMarshallers.bucketRefererMarshaller.marshall(referer)).build();
        this.doOperation(request, emptyResponseParser, bucketName, null);
    }

    public BucketReferer getBucketReferer(String bucketName) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("referer", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(params).build();
        return this.doOperation(request, ResponseParsers.getBucketRefererResponseParser, bucketName, null, true);
    }

    public String getBucketLocation(String bucketName) {
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("location", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(params).build();
        return this.doOperation(request, ResponseParsers.getBucketLocationResponseParser, bucketName, null, true);
    }

    public boolean doesBucketExists(String bucketName) throws OSSException, ClientException {
        block2: {
            CodingUtils.assertParameterNotNull(bucketName, "bucketName");
            OSSUtils.ensureBucketNameValid(bucketName);
            try {
                this.getBucketAcl(bucketName);
            }
            catch (OSSException e) {
                if (!e.getErrorCode().equals("NoSuchBucket")) break block2;
                return false;
            }
        }
        return true;
    }

    public ObjectListing listObjects(ListObjectsRequest listObjectsRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(listObjectsRequest, "listObjectsRequest");
        String bucketName = listObjectsRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        OSSBucketOperation.populateListObjectsRequestParameters(listObjectsRequest, params);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(params).build();
        return this.doOperation(request, ResponseParsers.listObjectsReponseParser, bucketName, null, true);
    }

    public void setBucketLogging(SetBucketLoggingRequest setBucketLoggingRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(setBucketLoggingRequest, "setBucketLoggingRequest");
        String bucketName = setBucketLoggingRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("logging", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.PUT).setBucket(bucketName).setParameters(params).setInputStreamWithLength(RequestMarshallers.setBucketLoggingRequestMarshaller.marshall(setBucketLoggingRequest)).build();
        this.doOperation(request, emptyResponseParser, bucketName, null);
    }

    public BucketLoggingResult getBucketLogging(String bucketName) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("logging", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(params).build();
        return this.doOperation(request, ResponseParsers.getBucketLoggingResponseParser, bucketName, null, true);
    }

    public void deleteBucketLogging(String bucketName) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("logging", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.DELETE).setBucket(bucketName).setParameters(params).build();
        this.doOperation(request, emptyResponseParser, bucketName, null);
    }

    public void setBucketWebsite(SetBucketWebsiteRequest setBucketWebSiteRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(setBucketWebSiteRequest, "setBucketWebSiteRequest");
        String bucketName = setBucketWebSiteRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        String indexDocument = setBucketWebSiteRequest.getIndexDocument();
        CodingUtils.assertParameterNotNull(indexDocument, "indexDocument");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("website", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.PUT).setBucket(bucketName).setParameters(params).setInputStreamWithLength(RequestMarshallers.setBucketWebsiteRequestMarshaller.marshall(setBucketWebSiteRequest)).build();
        this.doOperation(request, emptyResponseParser, bucketName, null);
    }

    public BucketWebsiteResult getBucketWebsite(String bucketName) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("website", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(params).build();
        return this.doOperation(request, ResponseParsers.getBucketWebsiteResponseParser, bucketName, null, true);
    }

    public void deleteBucketWebsite(String bucketName) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("website", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.DELETE).setBucket(bucketName).setParameters(params).build();
        this.doOperation(request, emptyResponseParser, bucketName, null);
    }

    public void setBucketLifecycle(SetBucketLifecycleRequest setBucketLifecycleRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(setBucketLifecycleRequest, "setBucketLifecycleRequest");
        String bucketName = setBucketLifecycleRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("lifecycle", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.PUT).setBucket(bucketName).setParameters(params).setInputStreamWithLength(RequestMarshallers.setBucketLifecycleRequestMarshaller.marshall(setBucketLifecycleRequest)).build();
        this.doOperation(request, emptyResponseParser, bucketName, null);
    }

    public List<LifecycleRule> getBucketLifecycle(String bucketName) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("lifecycle", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(params).build();
        return this.doOperation(request, ResponseParsers.getBucketLifecycleResponseParser, bucketName, null, true);
    }

    public void deleteBucketLifecycle(String bucketName) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("lifecycle", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.DELETE).setBucket(bucketName).setParameters(params).build();
        this.doOperation(request, emptyResponseParser, bucketName, null);
    }

    private static void populateListObjectsRequestParameters(ListObjectsRequest listObjectsRequest, Map<String, String> params) {
        if (listObjectsRequest.getPrefix() != null) {
            params.put("prefix", listObjectsRequest.getPrefix());
        }
        if (listObjectsRequest.getMarker() != null) {
            params.put("marker", listObjectsRequest.getMarker());
        }
        if (listObjectsRequest.getDelimiter() != null) {
            params.put("delimiter", listObjectsRequest.getDelimiter());
        }
        if (listObjectsRequest.getMaxKeys() != null) {
            params.put("max-keys", Integer.toString(listObjectsRequest.getMaxKeys()));
        }
        if (listObjectsRequest.getEncodingType() != null) {
            params.put("encoding-type", listObjectsRequest.getEncodingType());
        }
    }

    private static void addOptionalACLHeader(Map<String, String> headers, CannedAccessControlList cannedAcl) {
        if (cannedAcl != null) {
            headers.put("x-oss-acl", cannedAcl.toString());
        }
    }
}

