/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.oss.com.aliyun.oss.internal;

import alluxio.underfs.oss.com.aliyun.oss.ClientException;
import alluxio.underfs.oss.com.aliyun.oss.HttpMethod;
import alluxio.underfs.oss.com.aliyun.oss.OSSException;
import alluxio.underfs.oss.com.aliyun.oss.common.auth.CredentialsProvider;
import alluxio.underfs.oss.com.aliyun.oss.common.comm.RequestMessage;
import alluxio.underfs.oss.com.aliyun.oss.common.comm.ResponseMessage;
import alluxio.underfs.oss.com.aliyun.oss.common.comm.ServiceClient;
import alluxio.underfs.oss.com.aliyun.oss.common.parser.RequestMarshallers;
import alluxio.underfs.oss.com.aliyun.oss.common.utils.CodingUtils;
import alluxio.underfs.oss.com.aliyun.oss.common.utils.HttpUtil;
import alluxio.underfs.oss.com.aliyun.oss.common.utils.IOUtils;
import alluxio.underfs.oss.com.aliyun.oss.common.utils.LogUtils;
import alluxio.underfs.oss.com.aliyun.oss.internal.OSSOperation;
import alluxio.underfs.oss.com.aliyun.oss.internal.OSSRequestMessageBuilder;
import alluxio.underfs.oss.com.aliyun.oss.internal.OSSUtils;
import alluxio.underfs.oss.com.aliyun.oss.internal.ResponseParsers;
import alluxio.underfs.oss.com.aliyun.oss.model.AbortMultipartUploadRequest;
import alluxio.underfs.oss.com.aliyun.oss.model.CannedAccessControlList;
import alluxio.underfs.oss.com.aliyun.oss.model.CompleteMultipartUploadRequest;
import alluxio.underfs.oss.com.aliyun.oss.model.CompleteMultipartUploadResult;
import alluxio.underfs.oss.com.aliyun.oss.model.InitiateMultipartUploadRequest;
import alluxio.underfs.oss.com.aliyun.oss.model.InitiateMultipartUploadResult;
import alluxio.underfs.oss.com.aliyun.oss.model.ListMultipartUploadsRequest;
import alluxio.underfs.oss.com.aliyun.oss.model.ListPartsRequest;
import alluxio.underfs.oss.com.aliyun.oss.model.MultipartUploadListing;
import alluxio.underfs.oss.com.aliyun.oss.model.PartListing;
import alluxio.underfs.oss.com.aliyun.oss.model.UploadPartCopyRequest;
import alluxio.underfs.oss.com.aliyun.oss.model.UploadPartCopyResult;
import alluxio.underfs.oss.com.aliyun.oss.model.UploadPartRequest;
import alluxio.underfs.oss.com.aliyun.oss.model.UploadPartResult;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class OSSMultipartOperation
extends OSSOperation {
    private static final int LIST_PART_MAX_RETURNS = 1000;
    private static final int LIST_UPLOAD_MAX_RETURNS = 1000;
    private static final int MAX_PART_NUMBER = 10000;

    public OSSMultipartOperation(ServiceClient client, CredentialsProvider credsProvider) {
        super(client, credsProvider);
    }

    public void abortMultipartUpload(AbortMultipartUploadRequest abortMultipartUploadRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(abortMultipartUploadRequest, "abortMultipartUploadRequest");
        String key = abortMultipartUploadRequest.getKey();
        String bucketName = abortMultipartUploadRequest.getBucketName();
        String uploadId = abortMultipartUploadRequest.getUploadId();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        CodingUtils.assertParameterNotNull(key, "key");
        OSSUtils.ensureObjectKeyValid(key);
        CodingUtils.assertStringNotNullOrEmpty(uploadId, "uploadId");
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("uploadId", uploadId);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.DELETE).setBucket(bucketName).setKey(key).setParameters(parameters).build();
        this.doOperation(request, emptyResponseParser, bucketName, key);
    }

    public CompleteMultipartUploadResult completeMultipartUpload(CompleteMultipartUploadRequest completeMultipartUploadRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(completeMultipartUploadRequest, "completeMultipartUploadRequest");
        String key = completeMultipartUploadRequest.getKey();
        String bucketName = completeMultipartUploadRequest.getBucketName();
        String uploadId = completeMultipartUploadRequest.getUploadId();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        CodingUtils.assertParameterNotNull(key, "key");
        OSSUtils.ensureObjectKeyValid(key);
        CodingUtils.assertStringNotNullOrEmpty(uploadId, "uploadId");
        HashMap<String, String> headers = new HashMap<String, String>();
        OSSMultipartOperation.populateCompleteMultipartUploadOptionalHeaders(completeMultipartUploadRequest, headers);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("uploadId", uploadId);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.POST).setBucket(bucketName).setKey(key).setHeaders(headers).setParameters(parameters).setInputStreamWithLength(RequestMarshallers.completeMultipartUploadRequestMarshaller.marshall(completeMultipartUploadRequest)).build();
        return this.doOperation(request, ResponseParsers.completeMultipartUploadResponseParser, bucketName, key, true);
    }

    public InitiateMultipartUploadResult initiateMultipartUpload(InitiateMultipartUploadRequest initiateMultipartUploadRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(initiateMultipartUploadRequest, "initiateMultipartUploadRequest");
        String key = initiateMultipartUploadRequest.getKey();
        String bucketName = initiateMultipartUploadRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        CodingUtils.assertParameterNotNull(key, "key");
        OSSUtils.ensureObjectKeyValid(key);
        HashMap<String, String> headers = new HashMap<String, String>();
        if (initiateMultipartUploadRequest.getObjectMetadata() != null) {
            OSSUtils.populateRequestMetadata(headers, initiateMultipartUploadRequest.getObjectMetadata());
        }
        OSSUtils.removeHeader(headers, "Content-Length");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("uploads", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.POST).setBucket(bucketName).setKey(key).setHeaders(headers).setParameters(params).setInputStream(new ByteArrayInputStream(new byte[0])).setInputSize(0L).build();
        return this.doOperation(request, ResponseParsers.initiateMultipartUploadResponseParser, bucketName, key, true);
    }

    public MultipartUploadListing listMultipartUploads(ListMultipartUploadsRequest listMultipartUploadsRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(listMultipartUploadsRequest, "listMultipartUploadsRequest");
        String bucketName = listMultipartUploadsRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        OSSMultipartOperation.populateListMultipartUploadsRequestParameters(listMultipartUploadsRequest, params);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setBucket(bucketName).setParameters(params).build();
        return this.doOperation(request, ResponseParsers.listMultipartUploadsResponseParser, bucketName, null, true);
    }

    public PartListing listParts(ListPartsRequest listPartsRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(listPartsRequest, "listPartsRequest");
        String key = listPartsRequest.getKey();
        String bucketName = listPartsRequest.getBucketName();
        String uploadId = listPartsRequest.getUploadId();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        CodingUtils.assertParameterNotNull(key, "key");
        OSSUtils.ensureObjectKeyValid(key);
        CodingUtils.assertStringNotNullOrEmpty(uploadId, "uploadId");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        OSSMultipartOperation.populateListPartsRequestParameters(listPartsRequest, params);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.GET).setBucket(bucketName).setKey(key).setParameters(params).build();
        return this.doOperation(request, ResponseParsers.listPartsResponseParser, bucketName, key, true);
    }

    public UploadPartResult uploadPart(UploadPartRequest uploadPartRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(uploadPartRequest, "uploadPartRequest");
        String key = uploadPartRequest.getKey();
        String bucketName = uploadPartRequest.getBucketName();
        String uploadId = uploadPartRequest.getUploadId();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        CodingUtils.assertParameterNotNull(key, "key");
        OSSUtils.ensureObjectKeyValid(key);
        CodingUtils.assertStringNotNullOrEmpty(uploadId, "uploadId");
        if (uploadPartRequest.getInputStream() == null) {
            throw new IllegalArgumentException(OSSUtils.OSS_RESOURCE_MANAGER.getString("MustSetContentStream"));
        }
        InputStream repeatableInputStream = null;
        try {
            repeatableInputStream = IOUtils.newRepeatableInputStream(uploadPartRequest.buildPartialStream());
        }
        catch (IOException ex) {
            LogUtils.logException("Cannot wrap to repeatable input stream: ", ex);
            throw new ClientException("Cannot wrap to repeatable input stream: ", ex);
        }
        int partNumber = uploadPartRequest.getPartNumber();
        if (!CodingUtils.checkParamRange(partNumber, 0L, false, 10000L, true)) {
            throw new IllegalArgumentException(OSSUtils.OSS_RESOURCE_MANAGER.getString("PartNumberOutOfRange"));
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        OSSMultipartOperation.populateUploadPartOptionalHeaders(uploadPartRequest, headers);
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("partNumber", Integer.toString(partNumber));
        params.put("uploadId", uploadId);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.PUT).setBucket(bucketName).setKey(key).setParameters(params).setHeaders(headers).setInputStream(repeatableInputStream).setInputSize(uploadPartRequest.getPartSize()).setUseChunkEncoding(uploadPartRequest.isUseChunkEncoding()).build();
        ResponseMessage response = this.doOperation(request, emptyResponseParser, bucketName, key);
        UploadPartResult result = new UploadPartResult();
        result.setPartNumber(partNumber);
        result.setETag(OSSUtils.trimQuotes(response.getHeaders().get("ETag")));
        return result;
    }

    public UploadPartCopyResult uploadPartCopy(UploadPartCopyRequest uploadPartCopyRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(uploadPartCopyRequest, "uploadPartCopyRequest");
        String key = uploadPartCopyRequest.getKey();
        String bucketName = uploadPartCopyRequest.getBucketName();
        String uploadId = uploadPartCopyRequest.getUploadId();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        CodingUtils.assertParameterNotNull(key, "key");
        OSSUtils.ensureObjectKeyValid(key);
        CodingUtils.assertStringNotNullOrEmpty(uploadId, "uploadId");
        Long partSize = uploadPartCopyRequest.getPartSize();
        if (partSize != null && !CodingUtils.checkParamRange(partSize, 0L, true, 0x140000000L, true)) {
            throw new IllegalArgumentException(OSSUtils.OSS_RESOURCE_MANAGER.getString("FileSizeOutOfRange"));
        }
        int partNumber = uploadPartCopyRequest.getPartNumber();
        if (!CodingUtils.checkParamRange(partNumber, 0L, false, 10000L, true)) {
            throw new IllegalArgumentException(OSSUtils.OSS_RESOURCE_MANAGER.getString("PartNumberOutOfRange"));
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        OSSMultipartOperation.populateCopyPartRequestHeaders(uploadPartCopyRequest, headers);
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("partNumber", Integer.toString(partNumber));
        params.put("uploadId", uploadId);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint()).setMethod(HttpMethod.PUT).setBucket(bucketName).setKey(key).setParameters(params).setHeaders(headers).build();
        return this.doOperation(request, new ResponseParsers.UploadPartCopyResponseParser(partNumber), bucketName, key, true);
    }

    private static void populateListMultipartUploadsRequestParameters(ListMultipartUploadsRequest listMultipartUploadsRequest, Map<String, String> params) {
        Integer maxUploads;
        params.put("uploads", null);
        if (listMultipartUploadsRequest.getDelimiter() != null) {
            params.put("delimiter", listMultipartUploadsRequest.getDelimiter());
        }
        if (listMultipartUploadsRequest.getKeyMarker() != null) {
            params.put("key-marker", listMultipartUploadsRequest.getKeyMarker());
        }
        if ((maxUploads = listMultipartUploadsRequest.getMaxUploads()) != null) {
            if (!CodingUtils.checkParamRange(maxUploads.intValue(), 0L, true, 1000L, true)) {
                throw new IllegalArgumentException(OSSUtils.OSS_RESOURCE_MANAGER.getFormattedString("MaxUploadsOutOfRange", 1000));
            }
            params.put("max-uploads", listMultipartUploadsRequest.getMaxUploads().toString());
        }
        if (listMultipartUploadsRequest.getPrefix() != null) {
            params.put("prefix", listMultipartUploadsRequest.getPrefix());
        }
        if (listMultipartUploadsRequest.getUploadIdMarker() != null) {
            params.put("upload-id-marker", listMultipartUploadsRequest.getUploadIdMarker());
        }
    }

    private static void populateListPartsRequestParameters(ListPartsRequest listPartsRequest, Map<String, String> params) {
        Integer partNumberMarker;
        params.put("uploadId", listPartsRequest.getUploadId());
        Integer maxParts = listPartsRequest.getMaxParts();
        if (maxParts != null) {
            if (!CodingUtils.checkParamRange(maxParts.intValue(), 0L, true, 1000L, true)) {
                throw new IllegalArgumentException(OSSUtils.OSS_RESOURCE_MANAGER.getFormattedString("MaxPartsOutOfRange", 1000));
            }
            params.put("max-parts", maxParts.toString());
        }
        if ((partNumberMarker = listPartsRequest.getPartNumberMarker()) != null) {
            if (!CodingUtils.checkParamRange(partNumberMarker.intValue(), 0L, false, 10000L, true)) {
                throw new IllegalArgumentException(OSSUtils.OSS_RESOURCE_MANAGER.getString("PartNumberMarkerOutOfRange"));
            }
            params.put("part-number-marker", partNumberMarker.toString());
        }
    }

    private static void populateCopyPartRequestHeaders(UploadPartCopyRequest uploadPartCopyRequest, Map<String, String> headers) {
        if (uploadPartCopyRequest.getPartSize() != null) {
            headers.put("Content-Length", Long.toString(uploadPartCopyRequest.getPartSize()));
        }
        if (uploadPartCopyRequest.getMd5Digest() != null) {
            headers.put("Content-MD5", uploadPartCopyRequest.getMd5Digest());
        }
        String copySource = "/" + uploadPartCopyRequest.getSourceBucketName() + "/" + HttpUtil.urlEncode(uploadPartCopyRequest.getSourceKey(), "utf-8");
        headers.put("x-oss-copy-source", copySource);
        if (uploadPartCopyRequest.getBeginIndex() != null && uploadPartCopyRequest.getPartSize() != null) {
            String range = "bytes=" + uploadPartCopyRequest.getBeginIndex() + "-" + Long.toString(uploadPartCopyRequest.getBeginIndex() + uploadPartCopyRequest.getPartSize() - 1L);
            headers.put("x-oss-copy-source-range", range);
        }
        OSSUtils.addDateHeader(headers, "x-oss-copy-source-if-modified-since", uploadPartCopyRequest.getModifiedSinceConstraint());
        OSSUtils.addDateHeader(headers, "x-oss-copy-source-if-unmodified-since", uploadPartCopyRequest.getUnmodifiedSinceConstraint());
        OSSUtils.addStringListHeader(headers, "x-oss-copy-source-if-match", uploadPartCopyRequest.getMatchingETagConstraints());
        OSSUtils.addStringListHeader(headers, "x-oss-copy-source-if-none-match", uploadPartCopyRequest.getNonmatchingEtagConstraints());
    }

    private static void populateUploadPartOptionalHeaders(UploadPartRequest uploadPartRequest, Map<String, String> headers) {
        if (!uploadPartRequest.isUseChunkEncoding()) {
            long partSize = uploadPartRequest.getPartSize();
            if (!CodingUtils.checkParamRange(partSize, 0L, true, 0x140000000L, true)) {
                throw new IllegalArgumentException(OSSUtils.OSS_RESOURCE_MANAGER.getString("FileSizeOutOfRange"));
            }
            headers.put("Content-Length", Long.toString(partSize));
        }
        if (uploadPartRequest.getMd5Digest() != null) {
            headers.put("Content-MD5", uploadPartRequest.getMd5Digest());
        }
    }

    private static void populateCompleteMultipartUploadOptionalHeaders(CompleteMultipartUploadRequest completeMultipartUploadRequest, Map<String, String> headers) {
        CannedAccessControlList cannedACL = completeMultipartUploadRequest.getObjectACL();
        if (cannedACL != null) {
            if (OSSUtils.isAllowedAcl(cannedACL)) {
                headers.put("x-oss-object-acl", cannedACL.toString());
            } else {
                throw new IllegalArgumentException("Unsupported acl type, please specify one of Private/PublicRead/PublicReadWrite");
            }
        }
    }
}

