/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.oss.org.apache.http.protocol;

import alluxio.underfs.oss.org.apache.http.HttpException;
import alluxio.underfs.oss.org.apache.http.HttpRequest;
import alluxio.underfs.oss.org.apache.http.HttpRequestInterceptor;
import alluxio.underfs.oss.org.apache.http.annotation.Contract;
import alluxio.underfs.oss.org.apache.http.annotation.ThreadingBehavior;
import alluxio.underfs.oss.org.apache.http.params.HttpParams;
import alluxio.underfs.oss.org.apache.http.protocol.HttpContext;
import alluxio.underfs.oss.org.apache.http.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestUserAgent
implements HttpRequestInterceptor {
    private final String userAgent;

    public RequestUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public RequestUserAgent() {
        this(null);
    }

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("User-Agent")) {
            String s = null;
            HttpParams params = request.getParams();
            if (params != null) {
                s = (String)params.getParameter("http.useragent");
            }
            if (s == null) {
                s = this.userAgent;
            }
            if (s != null) {
                request.addHeader("User-Agent", s);
            }
        }
    }
}

