/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.oss.com.aliyun.oss.common.comm;

import alluxio.underfs.oss.com.aliyun.oss.ClientException;
import alluxio.underfs.oss.com.aliyun.oss.HttpMethod;
import alluxio.underfs.oss.com.aliyun.oss.common.comm.ExecutionContext;
import alluxio.underfs.oss.com.aliyun.oss.common.comm.RepeatableInputStreamEntity;
import alluxio.underfs.oss.com.aliyun.oss.common.comm.ServiceClient;
import alluxio.underfs.oss.com.aliyun.oss.common.comm.io.ChunkedInputStreamEntity;
import alluxio.underfs.oss.org.apache.http.HttpEntity;
import alluxio.underfs.oss.org.apache.http.client.methods.HttpDelete;
import alluxio.underfs.oss.org.apache.http.client.methods.HttpGet;
import alluxio.underfs.oss.org.apache.http.client.methods.HttpHead;
import alluxio.underfs.oss.org.apache.http.client.methods.HttpOptions;
import alluxio.underfs.oss.org.apache.http.client.methods.HttpPost;
import alluxio.underfs.oss.org.apache.http.client.methods.HttpPut;
import alluxio.underfs.oss.org.apache.http.client.methods.HttpRequestBase;
import java.util.Map;

class HttpRequestFactory {
    HttpRequestFactory() {
    }

    public HttpRequestBase createHttpRequest(ServiceClient.Request request, ExecutionContext context) {
        HttpRequestBase httpRequest;
        String uri = request.getUri();
        HttpMethod method = request.getMethod();
        if (method == HttpMethod.POST) {
            HttpPost postMethod = new HttpPost(uri);
            if (request.getContent() != null) {
                postMethod.setEntity(new RepeatableInputStreamEntity(request));
            }
            httpRequest = postMethod;
        } else if (method == HttpMethod.PUT) {
            HttpPut putMethod = new HttpPut(uri);
            if (request.getContent() != null) {
                if (request.isUseChunkEncoding()) {
                    putMethod.setEntity(this.buildChunkedInputStreamEntity(request));
                } else {
                    putMethod.setEntity(new RepeatableInputStreamEntity(request));
                }
            }
            httpRequest = putMethod;
        } else if (method == HttpMethod.GET) {
            httpRequest = new HttpGet(uri);
        } else if (method == HttpMethod.DELETE) {
            httpRequest = new HttpDelete(uri);
        } else if (method == HttpMethod.HEAD) {
            httpRequest = new HttpHead(uri);
        } else if (method == HttpMethod.OPTIONS) {
            httpRequest = new HttpOptions(uri);
        } else {
            throw new ClientException("Unknown HTTP method name: " + method.toString());
        }
        this.configureRequestHeaders(request, context, httpRequest);
        return httpRequest;
    }

    private HttpEntity buildChunkedInputStreamEntity(ServiceClient.Request request) {
        return new ChunkedInputStreamEntity(request);
    }

    private void configureRequestHeaders(ServiceClient.Request request, ExecutionContext context, HttpRequestBase httpRequest) {
        for (Map.Entry<String, String> entry : request.getHeaders().entrySet()) {
            if (entry.getKey().equalsIgnoreCase("Content-Length") || entry.getKey().equalsIgnoreCase("Host")) continue;
            httpRequest.addHeader(entry.getKey(), entry.getValue());
        }
    }
}

