/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.oss.com.aliyun.oss.internal;

import alluxio.underfs.oss.com.aliyun.oss.ClientException;
import alluxio.underfs.oss.com.aliyun.oss.HttpMethod;
import alluxio.underfs.oss.com.aliyun.oss.OSSException;
import alluxio.underfs.oss.com.aliyun.oss.ServiceException;
import alluxio.underfs.oss.com.aliyun.oss.common.auth.Credentials;
import alluxio.underfs.oss.com.aliyun.oss.common.auth.CredentialsProvider;
import alluxio.underfs.oss.com.aliyun.oss.common.auth.RequestSigner;
import alluxio.underfs.oss.com.aliyun.oss.common.comm.ExecutionContext;
import alluxio.underfs.oss.com.aliyun.oss.common.comm.NoRetryStrategy;
import alluxio.underfs.oss.com.aliyun.oss.common.comm.RequestHandler;
import alluxio.underfs.oss.com.aliyun.oss.common.comm.RequestMessage;
import alluxio.underfs.oss.com.aliyun.oss.common.comm.ResponseHandler;
import alluxio.underfs.oss.com.aliyun.oss.common.comm.ResponseMessage;
import alluxio.underfs.oss.com.aliyun.oss.common.comm.RetryStrategy;
import alluxio.underfs.oss.com.aliyun.oss.common.comm.ServiceClient;
import alluxio.underfs.oss.com.aliyun.oss.common.parser.ResponseParseException;
import alluxio.underfs.oss.com.aliyun.oss.common.parser.ResponseParser;
import alluxio.underfs.oss.com.aliyun.oss.common.utils.ExceptionFactory;
import alluxio.underfs.oss.com.aliyun.oss.common.utils.LogUtils;
import alluxio.underfs.oss.com.aliyun.oss.internal.OSSErrorResponseHandler;
import alluxio.underfs.oss.com.aliyun.oss.internal.OSSRequestSigner;
import alluxio.underfs.oss.com.aliyun.oss.internal.OSSUtils;
import alluxio.underfs.oss.com.aliyun.oss.internal.ResponseParsers;
import java.net.URI;
import java.util.List;

public abstract class OSSOperation {
    private volatile URI endpoint;
    private CredentialsProvider credsProvider;
    private ServiceClient client;
    protected static OSSErrorResponseHandler errorResponseHandler = new OSSErrorResponseHandler();
    protected static ResponseParsers.EmptyResponseParser emptyResponseParser = new ResponseParsers.EmptyResponseParser();
    protected static RetryStrategy noRetryStrategy = new NoRetryStrategy();

    protected OSSOperation(ServiceClient client, CredentialsProvider credsProvider) {
        this.client = client;
        this.credsProvider = credsProvider;
    }

    public URI getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(URI endpoint) {
        this.endpoint = URI.create(endpoint.toString());
    }

    protected ServiceClient getInnerClient() {
        return this.client;
    }

    protected ResponseMessage send(RequestMessage request, ExecutionContext context) throws OSSException, ClientException {
        return this.send(request, context, false);
    }

    protected ResponseMessage send(RequestMessage request, ExecutionContext context, boolean keepResponseOpen) throws OSSException, ClientException {
        ResponseMessage response = null;
        try {
            ResponseMessage responseMessage = response = this.client.sendRequest(request, context);
            return responseMessage;
        }
        catch (ServiceException e) {
            assert (e instanceof OSSException);
            throw (OSSException)e;
        }
        finally {
            if (response != null && !keepResponseOpen) {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    protected <T> T doOperation(RequestMessage request, ResponseParser<T> parser, String bucketName, String key) throws OSSException, ClientException {
        return this.doOperation(request, parser, bucketName, key, false);
    }

    protected <T> T doOperation(RequestMessage request, ResponseParser<T> parser, String bucketName, String key, boolean keepResponseOpen) throws OSSException, ClientException {
        return this.doOperation(request, parser, bucketName, key, keepResponseOpen, null, null);
    }

    protected <T> T doOperation(RequestMessage request, ResponseParser<T> parser, String bucketName, String key, boolean keepResponseOpen, List<RequestHandler> requestHandlers, List<ResponseHandler> reponseHandlers) throws OSSException, ClientException {
        ExecutionContext context = this.createDefaultContext(request.getMethod(), bucketName, key);
        if (context.getCredentials().useSecurityToken() && !request.isUseUrlSignature()) {
            request.addHeader("x-oss-security-token", context.getCredentials().getSecurityToken());
        }
        if (requestHandlers != null) {
            for (RequestHandler requestHandler : requestHandlers) {
                context.addRequestHandler(requestHandler);
            }
        }
        if (reponseHandlers != null) {
            for (ResponseHandler responseHandler : reponseHandlers) {
                context.addResponseHandler(responseHandler);
            }
        }
        ResponseMessage response = this.send(request, context, keepResponseOpen);
        try {
            return parser.parse(response);
        }
        catch (ResponseParseException responseParseException) {
            OSSException oe = ExceptionFactory.createInvalidResponseException(response.getRequestId(), response.getErrorResponseAsString(), responseParseException);
            LogUtils.logException("Unable to parse response error: ", oe);
            throw oe;
        }
    }

    private static RequestSigner createSigner(HttpMethod method, String bucketName, String key, Credentials creds) {
        String resourcePath = "/" + (bucketName != null ? bucketName + "/" : "") + (key != null ? key : "");
        return new OSSRequestSigner(method.toString(), resourcePath, creds);
    }

    protected ExecutionContext createDefaultContext(HttpMethod method, String bucketName, String key) {
        ExecutionContext context = new ExecutionContext();
        context.setCharset("utf-8");
        context.setSigner(OSSOperation.createSigner(method, bucketName, key, this.credsProvider.getCredentials()));
        context.addResponseHandler(errorResponseHandler);
        if (method == HttpMethod.POST) {
            context.setRetryStrategy(noRetryStrategy);
        }
        context.setCredentials(this.credsProvider.getCredentials());
        return context;
    }

    protected ExecutionContext createDefaultContext(HttpMethod method, String bucketName) {
        return this.createDefaultContext(method, bucketName, null);
    }

    protected ExecutionContext createDefaultContext(HttpMethod method) {
        return this.createDefaultContext(method, null, null);
    }
}

