/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.oss.org.apache.commons.beanutils;

import alluxio.underfs.oss.org.apache.commons.beanutils.ContextClassLoaderLocal;
import alluxio.underfs.oss.org.apache.commons.beanutils.DynaBean;
import alluxio.underfs.oss.org.apache.commons.beanutils.DynaClass;
import alluxio.underfs.oss.org.apache.commons.beanutils.DynaProperty;
import alluxio.underfs.oss.org.apache.commons.beanutils.PropertyUtils;
import alluxio.underfs.oss.org.apache.commons.beanutils.WrapDynaBean;
import java.beans.PropertyDescriptor;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public class WrapDynaClass
implements DynaClass {
    private String beanClassName = null;
    private Reference beanClassRef = null;
    protected Class beanClass = null;
    protected PropertyDescriptor[] descriptors = null;
    protected HashMap descriptorsMap = new HashMap();
    protected DynaProperty[] properties = null;
    protected HashMap propertiesMap = new HashMap();
    private static final ContextClassLoaderLocal CLASSLOADER_CACHE = new ContextClassLoaderLocal(){

        protected Object initialValue() {
            return new WeakHashMap();
        }
    };
    protected static HashMap dynaClasses = new HashMap(){

        public void clear() {
            WrapDynaClass.getDynaClassesMap().clear();
        }

        public boolean containsKey(Object key) {
            return WrapDynaClass.getDynaClassesMap().containsKey(key);
        }

        public boolean containsValue(Object value) {
            return WrapDynaClass.getDynaClassesMap().containsValue(value);
        }

        public Set entrySet() {
            return WrapDynaClass.getDynaClassesMap().entrySet();
        }

        public boolean equals(Object o) {
            return ((Object)WrapDynaClass.getDynaClassesMap()).equals(o);
        }

        public Object get(Object key) {
            return WrapDynaClass.getDynaClassesMap().get(key);
        }

        public int hashCode() {
            return ((Object)WrapDynaClass.getDynaClassesMap()).hashCode();
        }

        public boolean isEmpty() {
            return WrapDynaClass.getDynaClassesMap().isEmpty();
        }

        public Set keySet() {
            return WrapDynaClass.getDynaClassesMap().keySet();
        }

        public Object put(Object key, Object value) {
            return WrapDynaClass.getDynaClassesMap().put(key, value);
        }

        public void putAll(Map m) {
            WrapDynaClass.getDynaClassesMap().putAll(m);
        }

        public Object remove(Object key) {
            return WrapDynaClass.getDynaClassesMap().remove(key);
        }

        public int size() {
            return WrapDynaClass.getDynaClassesMap().size();
        }

        public Collection values() {
            return WrapDynaClass.getDynaClassesMap().values();
        }
    };
    static /* synthetic */ Class class$java$util$Map;

    private WrapDynaClass(Class beanClass) {
        this.beanClassRef = new SoftReference<Class>(beanClass);
        this.beanClassName = beanClass.getName();
        this.introspect();
    }

    private static Map getDynaClassesMap() {
        return (Map)CLASSLOADER_CACHE.get();
    }

    protected Class getBeanClass() {
        return (Class)this.beanClassRef.get();
    }

    public String getName() {
        return this.beanClassName;
    }

    public DynaProperty getDynaProperty(String name) {
        if (name == null) {
            throw new IllegalArgumentException("No property name specified");
        }
        return (DynaProperty)this.propertiesMap.get(name);
    }

    public DynaProperty[] getDynaProperties() {
        return this.properties;
    }

    public DynaBean newInstance() throws IllegalAccessException, InstantiationException {
        return new WrapDynaBean(this.getBeanClass().newInstance());
    }

    public PropertyDescriptor getPropertyDescriptor(String name) {
        return (PropertyDescriptor)this.descriptorsMap.get(name);
    }

    public static void clear() {
        WrapDynaClass.getDynaClassesMap().clear();
    }

    public static WrapDynaClass createDynaClass(Class beanClass) {
        WrapDynaClass dynaClass = (WrapDynaClass)WrapDynaClass.getDynaClassesMap().get(beanClass);
        if (dynaClass == null) {
            dynaClass = new WrapDynaClass(beanClass);
            WrapDynaClass.getDynaClassesMap().put(beanClass, dynaClass);
        }
        return dynaClass;
    }

    protected void introspect() {
        HashMap mappeds;
        Class beanClass = this.getBeanClass();
        PropertyDescriptor[] regulars = PropertyUtils.getPropertyDescriptors(beanClass);
        if (regulars == null) {
            regulars = new PropertyDescriptor[]{};
        }
        if ((mappeds = PropertyUtils.getMappedPropertyDescriptors(beanClass)) == null) {
            mappeds = new HashMap();
        }
        this.properties = new DynaProperty[regulars.length + mappeds.size()];
        for (int i = 0; i < regulars.length; ++i) {
            this.descriptorsMap.put(regulars[i].getName(), regulars[i]);
            this.properties[i] = new DynaProperty(regulars[i].getName(), regulars[i].getPropertyType());
            this.propertiesMap.put(this.properties[i].getName(), this.properties[i]);
        }
        int j = regulars.length;
        Iterator names = mappeds.keySet().iterator();
        while (names.hasNext()) {
            String name = (String)names.next();
            PropertyDescriptor descriptor = (PropertyDescriptor)mappeds.get(name);
            this.properties[j] = new DynaProperty(descriptor.getName(), class$java$util$Map == null ? WrapDynaClass.class$("java.util.Map") : class$java$util$Map);
            this.propertiesMap.put(this.properties[j].getName(), this.properties[j]);
            ++j;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

