/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.oss.org.apache.commons.beanutils.locale;

import alluxio.underfs.oss.org.apache.commons.beanutils.BeanUtils;
import alluxio.underfs.oss.org.apache.commons.beanutils.locale.LocaleBeanUtilsBean;
import alluxio.underfs.oss.org.apache.commons.beanutils.locale.LocaleConverter;
import alluxio.underfs.oss.org.apache.commons.beanutils.locale.converters.BigDecimalLocaleConverter;
import alluxio.underfs.oss.org.apache.commons.beanutils.locale.converters.BigIntegerLocaleConverter;
import alluxio.underfs.oss.org.apache.commons.beanutils.locale.converters.ByteLocaleConverter;
import alluxio.underfs.oss.org.apache.commons.beanutils.locale.converters.DoubleLocaleConverter;
import alluxio.underfs.oss.org.apache.commons.beanutils.locale.converters.FloatLocaleConverter;
import alluxio.underfs.oss.org.apache.commons.beanutils.locale.converters.IntegerLocaleConverter;
import alluxio.underfs.oss.org.apache.commons.beanutils.locale.converters.LongLocaleConverter;
import alluxio.underfs.oss.org.apache.commons.beanutils.locale.converters.ShortLocaleConverter;
import alluxio.underfs.oss.org.apache.commons.beanutils.locale.converters.SqlDateLocaleConverter;
import alluxio.underfs.oss.org.apache.commons.beanutils.locale.converters.SqlTimeLocaleConverter;
import alluxio.underfs.oss.org.apache.commons.beanutils.locale.converters.SqlTimestampLocaleConverter;
import alluxio.underfs.oss.org.apache.commons.beanutils.locale.converters.StringLocaleConverter;
import alluxio.underfs.oss.org.apache.commons.collections.FastHashMap;
import alluxio.underfs.oss.org.apache.commons.logging.Log;
import alluxio.underfs.oss.org.apache.commons.logging.LogFactory;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class LocaleConvertUtilsBean {
    private Locale defaultLocale = Locale.getDefault();
    private boolean applyLocalized = false;
    private Log log = LogFactory.getLog(class$org$apache$commons$beanutils$locale$LocaleConvertUtils == null ? (class$org$apache$commons$beanutils$locale$LocaleConvertUtils = LocaleConvertUtilsBean.class$("alluxio.underfs.oss.org.apache.commons.beanutils.locale.LocaleConvertUtils")) : class$org$apache$commons$beanutils$locale$LocaleConvertUtils);
    private FastHashMap mapConverters = new DelegateFastHashMap(BeanUtils.createCache());
    static /* synthetic */ Class class$org$apache$commons$beanutils$locale$LocaleConvertUtils;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Timestamp;

    public static LocaleConvertUtilsBean getInstance() {
        return LocaleBeanUtilsBean.getLocaleBeanUtilsInstance().getLocaleConvertUtils();
    }

    public LocaleConvertUtilsBean() {
        this.mapConverters.setFast(false);
        this.deregister();
        this.mapConverters.setFast(true);
    }

    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    public void setDefaultLocale(Locale locale) {
        this.defaultLocale = locale == null ? Locale.getDefault() : locale;
    }

    public boolean getApplyLocalized() {
        return this.applyLocalized;
    }

    public void setApplyLocalized(boolean newApplyLocalized) {
        this.applyLocalized = newApplyLocalized;
    }

    public String convert(Object value) {
        return this.convert(value, this.defaultLocale, null);
    }

    public String convert(Object value, String pattern) {
        return this.convert(value, this.defaultLocale, pattern);
    }

    public String convert(Object value, Locale locale, String pattern) {
        LocaleConverter converter = this.lookup(class$java$lang$String == null ? (class$java$lang$String = LocaleConvertUtilsBean.class$("java.lang.String")) : class$java$lang$String, locale);
        return (String)converter.convert(class$java$lang$String == null ? (class$java$lang$String = LocaleConvertUtilsBean.class$("java.lang.String")) : class$java$lang$String, value, pattern);
    }

    public Object convert(String value, Class clazz) {
        return this.convert(value, clazz, this.defaultLocale, null);
    }

    public Object convert(String value, Class clazz, String pattern) {
        return this.convert(value, clazz, this.defaultLocale, pattern);
    }

    public Object convert(String value, Class clazz, Locale locale, String pattern) {
        LocaleConverter converter;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Convert string " + value + " to class " + clazz.getName() + " using " + locale + " locale and " + pattern + " pattern");
        }
        if ((converter = this.lookup(clazz, locale)) == null) {
            converter = this.lookup(class$java$lang$String == null ? (class$java$lang$String = LocaleConvertUtilsBean.class$("java.lang.String")) : class$java$lang$String, locale);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("  Using converter " + converter);
        }
        return converter.convert(clazz, value, pattern);
    }

    public Object convert(String[] values, Class clazz, String pattern) {
        return this.convert(values, clazz, this.getDefaultLocale(), pattern);
    }

    public Object convert(String[] values, Class clazz) {
        return this.convert(values, clazz, this.getDefaultLocale(), null);
    }

    public Object convert(String[] values, Class clazz, Locale locale, String pattern) {
        Class<?> type = clazz;
        if (clazz.isArray()) {
            type = clazz.getComponentType();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Convert String[" + values.length + "] to class " + type.getName() + "[] using " + locale + " locale and " + pattern + " pattern");
        }
        Object array = Array.newInstance(type, values.length);
        for (int i = 0; i < values.length; ++i) {
            Array.set(array, i, this.convert(values[i], type, locale, pattern));
        }
        return array;
    }

    public void register(LocaleConverter converter, Class clazz, Locale locale) {
        this.lookup(locale).put(clazz, converter);
    }

    public void deregister() {
        FastHashMap defaultConverter = this.lookup(this.defaultLocale);
        this.mapConverters.setFast(false);
        this.mapConverters.clear();
        this.mapConverters.put(this.defaultLocale, defaultConverter);
        this.mapConverters.setFast(true);
    }

    public void deregister(Locale locale) {
        this.mapConverters.remove(locale);
    }

    public void deregister(Class clazz, Locale locale) {
        this.lookup(locale).remove(clazz);
    }

    public LocaleConverter lookup(Class clazz, Locale locale) {
        LocaleConverter converter = (LocaleConverter)this.lookup(locale).get(clazz);
        if (this.log.isTraceEnabled()) {
            this.log.trace("LocaleConverter:" + converter);
        }
        return converter;
    }

    protected FastHashMap lookup(Locale locale) {
        FastHashMap localeConverters;
        if (locale == null) {
            localeConverters = (FastHashMap)this.mapConverters.get(this.defaultLocale);
        } else {
            localeConverters = (FastHashMap)this.mapConverters.get(locale);
            if (localeConverters == null) {
                localeConverters = this.create(locale);
                this.mapConverters.put(locale, localeConverters);
            }
        }
        return localeConverters;
    }

    protected FastHashMap create(Locale locale) {
        DelegateFastHashMap converter = new DelegateFastHashMap(BeanUtils.createCache());
        ((FastHashMap)converter).setFast(false);
        ((FastHashMap)converter).put(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = LocaleConvertUtilsBean.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, new BigDecimalLocaleConverter(locale, this.applyLocalized));
        ((FastHashMap)converter).put(class$java$math$BigInteger == null ? (class$java$math$BigInteger = LocaleConvertUtilsBean.class$("java.math.BigInteger")) : class$java$math$BigInteger, new BigIntegerLocaleConverter(locale, this.applyLocalized));
        ((FastHashMap)converter).put(class$java$lang$Byte == null ? (class$java$lang$Byte = LocaleConvertUtilsBean.class$("java.lang.Byte")) : class$java$lang$Byte, new ByteLocaleConverter(locale, this.applyLocalized));
        ((FastHashMap)converter).put(Byte.TYPE, new ByteLocaleConverter(locale, this.applyLocalized));
        ((FastHashMap)converter).put(class$java$lang$Double == null ? (class$java$lang$Double = LocaleConvertUtilsBean.class$("java.lang.Double")) : class$java$lang$Double, new DoubleLocaleConverter(locale, this.applyLocalized));
        ((FastHashMap)converter).put(Double.TYPE, new DoubleLocaleConverter(locale, this.applyLocalized));
        ((FastHashMap)converter).put(class$java$lang$Float == null ? (class$java$lang$Float = LocaleConvertUtilsBean.class$("java.lang.Float")) : class$java$lang$Float, new FloatLocaleConverter(locale, this.applyLocalized));
        ((FastHashMap)converter).put(Float.TYPE, new FloatLocaleConverter(locale, this.applyLocalized));
        ((FastHashMap)converter).put(class$java$lang$Integer == null ? (class$java$lang$Integer = LocaleConvertUtilsBean.class$("java.lang.Integer")) : class$java$lang$Integer, new IntegerLocaleConverter(locale, this.applyLocalized));
        ((FastHashMap)converter).put(Integer.TYPE, new IntegerLocaleConverter(locale, this.applyLocalized));
        ((FastHashMap)converter).put(class$java$lang$Long == null ? (class$java$lang$Long = LocaleConvertUtilsBean.class$("java.lang.Long")) : class$java$lang$Long, new LongLocaleConverter(locale, this.applyLocalized));
        ((FastHashMap)converter).put(Long.TYPE, new LongLocaleConverter(locale, this.applyLocalized));
        ((FastHashMap)converter).put(class$java$lang$Short == null ? (class$java$lang$Short = LocaleConvertUtilsBean.class$("java.lang.Short")) : class$java$lang$Short, new ShortLocaleConverter(locale, this.applyLocalized));
        ((FastHashMap)converter).put(Short.TYPE, new ShortLocaleConverter(locale, this.applyLocalized));
        ((FastHashMap)converter).put(class$java$lang$String == null ? (class$java$lang$String = LocaleConvertUtilsBean.class$("java.lang.String")) : class$java$lang$String, new StringLocaleConverter(locale, this.applyLocalized));
        ((FastHashMap)converter).put(class$java$sql$Date == null ? (class$java$sql$Date = LocaleConvertUtilsBean.class$("java.sql.Date")) : class$java$sql$Date, new SqlDateLocaleConverter(locale, "yyyy-MM-dd"));
        ((FastHashMap)converter).put(class$java$sql$Time == null ? (class$java$sql$Time = LocaleConvertUtilsBean.class$("java.sql.Time")) : class$java$sql$Time, new SqlTimeLocaleConverter(locale, "HH:mm:ss"));
        ((FastHashMap)converter).put(class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = LocaleConvertUtilsBean.class$("java.sql.Timestamp")) : class$java$sql$Timestamp, new SqlTimestampLocaleConverter(locale, "yyyy-MM-dd HH:mm:ss.S"));
        ((FastHashMap)converter).setFast(true);
        return converter;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class DelegateFastHashMap
    extends FastHashMap {
        private final Map map;

        private DelegateFastHashMap(Map map) {
            this.map = map;
        }

        public void clear() {
            this.map.clear();
        }

        public boolean containsKey(Object key) {
            return this.map.containsKey(key);
        }

        public boolean containsValue(Object value) {
            return this.map.containsValue(value);
        }

        public Set entrySet() {
            return this.map.entrySet();
        }

        public boolean equals(Object o) {
            return ((Object)this.map).equals(o);
        }

        public Object get(Object key) {
            return this.map.get(key);
        }

        public int hashCode() {
            return ((Object)this.map).hashCode();
        }

        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        public Set keySet() {
            return this.map.keySet();
        }

        public Object put(Object key, Object value) {
            return this.map.put(key, value);
        }

        public void putAll(Map m) {
            this.map.putAll(m);
        }

        public Object remove(Object key) {
            return this.map.remove(key);
        }

        public int size() {
            return this.map.size();
        }

        public Collection values() {
            return this.map.values();
        }

        public boolean getFast() {
            return BeanUtils.getCacheFast(this.map);
        }

        public void setFast(boolean fast) {
            BeanUtils.setCacheFast(this.map, fast);
        }
    }
}

