/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.oss.org.apache.http.client.protocol;

import alluxio.underfs.oss.org.apache.http.HttpException;
import alluxio.underfs.oss.org.apache.http.HttpRequest;
import alluxio.underfs.oss.org.apache.http.HttpRequestInterceptor;
import alluxio.underfs.oss.org.apache.http.annotation.Contract;
import alluxio.underfs.oss.org.apache.http.annotation.ThreadingBehavior;
import alluxio.underfs.oss.org.apache.http.client.config.RequestConfig;
import alluxio.underfs.oss.org.apache.http.client.protocol.HttpClientContext;
import alluxio.underfs.oss.org.apache.http.protocol.HttpContext;
import java.io.IOException;
import java.util.List;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestAcceptEncoding
implements HttpRequestInterceptor {
    private final String acceptEncoding;

    public RequestAcceptEncoding(List<String> encodings) {
        if (encodings != null && !encodings.isEmpty()) {
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < encodings.size(); ++i) {
                if (i > 0) {
                    buf.append(",");
                }
                buf.append(encodings.get(i));
            }
            this.acceptEncoding = buf.toString();
        } else {
            this.acceptEncoding = "gzip,deflate";
        }
    }

    public RequestAcceptEncoding() {
        this(null);
    }

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        RequestConfig requestConfig = clientContext.getRequestConfig();
        if (!request.containsHeader("Accept-Encoding") && requestConfig.isContentCompressionEnabled()) {
            request.addHeader("Accept-Encoding", this.acceptEncoding);
        }
    }
}

