/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.oss.org.apache.http.protocol;

import alluxio.underfs.oss.org.apache.http.HttpConnection;
import alluxio.underfs.oss.org.apache.http.HttpException;
import alluxio.underfs.oss.org.apache.http.HttpHost;
import alluxio.underfs.oss.org.apache.http.HttpInetConnection;
import alluxio.underfs.oss.org.apache.http.HttpRequest;
import alluxio.underfs.oss.org.apache.http.HttpRequestInterceptor;
import alluxio.underfs.oss.org.apache.http.HttpVersion;
import alluxio.underfs.oss.org.apache.http.ProtocolException;
import alluxio.underfs.oss.org.apache.http.ProtocolVersion;
import alluxio.underfs.oss.org.apache.http.annotation.Contract;
import alluxio.underfs.oss.org.apache.http.annotation.ThreadingBehavior;
import alluxio.underfs.oss.org.apache.http.protocol.HttpContext;
import alluxio.underfs.oss.org.apache.http.protocol.HttpCoreContext;
import alluxio.underfs.oss.org.apache.http.util.Args;
import java.io.IOException;
import java.net.InetAddress;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestTargetHost
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        HttpCoreContext corecontext = HttpCoreContext.adapt(context);
        ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT") && ver.lessEquals(HttpVersion.HTTP_1_0)) {
            return;
        }
        if (!request.containsHeader("Host")) {
            HttpHost targethost = corecontext.getTargetHost();
            if (targethost == null) {
                HttpConnection conn = corecontext.getConnection();
                if (conn instanceof HttpInetConnection) {
                    InetAddress address = ((HttpInetConnection)conn).getRemoteAddress();
                    int port = ((HttpInetConnection)conn).getRemotePort();
                    if (address != null) {
                        targethost = new HttpHost(address.getHostName(), port);
                    }
                }
                if (targethost == null) {
                    if (ver.lessEquals(HttpVersion.HTTP_1_0)) {
                        return;
                    }
                    throw new ProtocolException("Target host missing");
                }
            }
            request.addHeader("Host", targethost.toHostString());
        }
    }
}

