/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.oss;

import alluxio.underfs.MultiRangeObjectInputStream;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.ObjectMetadata;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class OSSInputStream
extends MultiRangeObjectInputStream {
    private final String mBucketName;
    private final String mKey;
    private final OSSClient mOssClient;
    private final long mContentLength;

    OSSInputStream(String bucketName, String key, OSSClient client, long multiRangeChunkSize) throws IOException {
        this(bucketName, key, client, 0L, multiRangeChunkSize);
    }

    OSSInputStream(String bucketName, String key, OSSClient client, long position, long multiRangeChunkSize) throws IOException {
        super(multiRangeChunkSize);
        this.mBucketName = bucketName;
        this.mKey = key;
        this.mOssClient = client;
        this.mPos = position;
        ObjectMetadata meta = this.mOssClient.getObjectMetadata(this.mBucketName, key);
        this.mContentLength = meta == null ? 0L : meta.getContentLength();
    }

    protected InputStream createStream(long startPos, long endPos) throws IOException {
        GetObjectRequest req = new GetObjectRequest(this.mBucketName, this.mKey);
        req.setRange(startPos, endPos < this.mContentLength ? endPos - 1L : this.mContentLength - 1L);
        OSSObject ossObject = this.mOssClient.getObject(req);
        return new BufferedInputStream(ossObject.getObjectContent());
    }
}

