/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.oss;

import alluxio.retry.RetryPolicy;
import alluxio.underfs.MultiRangeObjectInputStream;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.ObjectMetadata;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class OSSInputStream
extends MultiRangeObjectInputStream {
    private static final Logger LOG = LoggerFactory.getLogger(OSSInputStream.class);
    private final String mBucketName;
    private final String mKey;
    private final OSSClient mOssClient;
    private final long mContentLength;
    private final RetryPolicy mRetryPolicy;

    OSSInputStream(String bucketName, String key, OSSClient client, RetryPolicy retryPolicy, long multiRangeChunkSize) throws IOException {
        this(bucketName, key, client, 0L, retryPolicy, multiRangeChunkSize);
    }

    OSSInputStream(String bucketName, String key, OSSClient client, long position, RetryPolicy retryPolicy, long multiRangeChunkSize) throws IOException {
        super(multiRangeChunkSize);
        this.mBucketName = bucketName;
        this.mKey = key;
        this.mOssClient = client;
        this.mPos = position;
        ObjectMetadata meta = this.mOssClient.getObjectMetadata(this.mBucketName, key);
        this.mContentLength = meta == null ? 0L : meta.getContentLength();
        this.mRetryPolicy = retryPolicy;
    }

    protected InputStream createStream(long startPos, long endPos) throws IOException {
        GetObjectRequest req = new GetObjectRequest(this.mBucketName, this.mKey);
        req.setRange(startPos, endPos < this.mContentLength ? endPos - 1L : this.mContentLength - 1L);
        OSSException lastException = null;
        while (this.mRetryPolicy.attempt()) {
            try {
                OSSObject ossObject = this.mOssClient.getObject(req);
                return new BufferedInputStream(ossObject.getObjectContent());
            }
            catch (OSSException e) {
                LOG.warn("Attempt {} to open key {} in bucket {} failed with exception : {}", new Object[]{this.mRetryPolicy.getAttemptCount(), this.mKey, this.mBucketName, e.toString()});
                if (!e.getErrorCode().equals("NoSuchKey")) {
                    throw new IOException(e);
                }
                lastException = e;
            }
        }
        throw new IOException(lastException);
    }
}

