/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.oss;

import alluxio.retry.RetryPolicy;
import alluxio.underfs.MultiRangeObjectInputStream;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.ObjectMetadata;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class OSSInputStream
extends MultiRangeObjectInputStream {
    private static final Logger LOG = LoggerFactory.getLogger(OSSInputStream.class);
    private final String mBucketName;
    private final String mKey;
    private final OSS mOssClient;
    private final long mContentLength;
    private final RetryPolicy mRetryPolicy;

    OSSInputStream(String bucketName, String key, OSS client, RetryPolicy retryPolicy, long multiRangeChunkSize) throws IOException {
        this(bucketName, key, client, 0L, retryPolicy, multiRangeChunkSize);
    }

    OSSInputStream(String bucketName, String key, OSS client, long position, RetryPolicy retryPolicy, long multiRangeChunkSize) throws IOException {
        super(multiRangeChunkSize);
        this.mBucketName = bucketName;
        this.mKey = key;
        this.mOssClient = client;
        this.mPos = position;
        ObjectMetadata meta = this.mOssClient.getObjectMetadata(this.mBucketName, key);
        this.mContentLength = meta == null ? 0L : meta.getContentLength();
        this.mRetryPolicy = retryPolicy;
    }

    protected InputStream createStream(long startPos, long endPos) throws IOException {
        GetObjectRequest req = new GetObjectRequest(this.mBucketName, this.mKey);
        req.setRange(startPos, endPos < this.mContentLength ? endPos - 1L : this.mContentLength - 1L);
        OSSException lastException = null;
        String errorMessage = String.format("Failed to open key: %s bucket: %s", this.mKey, this.mBucketName);
        while (this.mRetryPolicy.attempt()) {
            try {
                OSSObject ossObject = this.mOssClient.getObject(req);
                return new BufferedInputStream(ossObject.getObjectContent());
            }
            catch (OSSException e) {
                errorMessage = String.format("Failed to open key: %s bucket: %s attempts: %d error: %s", this.mKey, this.mBucketName, this.mRetryPolicy.getAttemptCount(), e.getMessage());
                if (!e.getErrorCode().equals("NoSuchKey")) {
                    throw new IOException(errorMessage, e);
                }
                lastException = e;
            }
        }
        throw new IOException(errorMessage, lastException);
    }
}

