/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.oss;

import alluxio.AlluxioURI;
import alluxio.conf.PropertyKey;
import alluxio.underfs.UnderFileSystem;
import alluxio.underfs.UnderFileSystemConfiguration;
import alluxio.underfs.UnderFileSystemFactory;
import alluxio.underfs.oss.OSSUnderFileSystem;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.IOException;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class OSSUnderFileSystemFactory
implements UnderFileSystemFactory {
    public UnderFileSystem create(String path, UnderFileSystemConfiguration conf) {
        Preconditions.checkNotNull((Object)path, (Object)"path");
        if (this.checkOSSCredentials(conf)) {
            try {
                return OSSUnderFileSystem.createInstance(new AlluxioURI(path), conf);
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        String err = "OSS Credentials not available, cannot create OSS Under File System.";
        throw Throwables.propagate((Throwable)new IOException(err));
    }

    public boolean supportsPath(String path) {
        return path != null && path.startsWith("oss://");
    }

    private boolean checkOSSCredentials(UnderFileSystemConfiguration conf) {
        return conf.isSet(PropertyKey.OSS_ACCESS_KEY) && conf.isSet(PropertyKey.OSS_SECRET_KEY) && conf.isSet(PropertyKey.OSS_ENDPOINT_KEY);
    }
}

