/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.oss;

import alluxio.AlluxioURI;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.retry.RetryPolicy;
import alluxio.underfs.ObjectUnderFileSystem;
import alluxio.underfs.UnderFileSystemConfiguration;
import alluxio.underfs.options.OpenOptions;
import alluxio.underfs.oss.OSSInputStream;
import alluxio.underfs.oss.OSSOutputStream;
import alluxio.underfs.oss.StsOssClientProvider;
import alluxio.util.UnderFileSystemUtils;
import alluxio.util.io.PathUtils;
import com.aliyun.oss.ClientBuilderConfiguration;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.ServiceException;
import com.aliyun.oss.model.ListObjectsRequest;
import com.aliyun.oss.model.OSSObjectSummary;
import com.aliyun.oss.model.ObjectListing;
import com.aliyun.oss.model.ObjectMetadata;
import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class OSSUnderFileSystem
extends ObjectUnderFileSystem {
    private static final Logger LOG = LoggerFactory.getLogger(OSSUnderFileSystem.class);
    private static final String FOLDER_SUFFIX = "_$folder$";
    private final OSS mClient;
    private final String mBucketName;
    private StsOssClientProvider mClientProvider;

    public static OSSUnderFileSystem createInstance(AlluxioURI uri, UnderFileSystemConfiguration conf) throws Exception {
        String bucketName = UnderFileSystemUtils.getBucketName((AlluxioURI)uri);
        return new OSSUnderFileSystem(uri, null, bucketName, conf);
    }

    protected OSSUnderFileSystem(AlluxioURI uri, @Nullable OSS ossClient, String bucketName, UnderFileSystemConfiguration conf) {
        super(uri, conf);
        if (conf.getBoolean(PropertyKey.UNDERFS_OSS_STS_ENABLED)) {
            try {
                this.mClientProvider = new StsOssClientProvider(conf);
                this.mClientProvider.init();
                this.mClient = this.mClientProvider.getOSSClient();
            }
            catch (IOException e) {
                LOG.error("init sts client provider failed!", (Throwable)e);
                throw new ServiceException((Throwable)e);
            }
        } else if (null != ossClient) {
            this.mClient = ossClient;
        } else {
            Preconditions.checkArgument((boolean)conf.isSet(PropertyKey.OSS_ACCESS_KEY), (String)"Property %s is required to connect to OSS", (Object)PropertyKey.OSS_ACCESS_KEY);
            Preconditions.checkArgument((boolean)conf.isSet(PropertyKey.OSS_SECRET_KEY), (String)"Property %s is required to connect to OSS", (Object)PropertyKey.OSS_SECRET_KEY);
            Preconditions.checkArgument((boolean)conf.isSet(PropertyKey.OSS_ENDPOINT_KEY), (String)"Property %s is required to connect to OSS", (Object)PropertyKey.OSS_ENDPOINT_KEY);
            String accessId = conf.getString(PropertyKey.OSS_ACCESS_KEY);
            String accessKey = conf.getString(PropertyKey.OSS_SECRET_KEY);
            String endPoint = conf.getString(PropertyKey.OSS_ENDPOINT_KEY);
            ClientBuilderConfiguration ossClientConf = OSSUnderFileSystem.initializeOSSClientConfig((AlluxioConfiguration)conf);
            this.mClient = new OSSClientBuilder().build(endPoint, accessId, accessKey, ossClientConf);
        }
        this.mBucketName = bucketName;
    }

    public String getUnderFSType() {
        return "oss";
    }

    public void setOwner(String path, String user, String group) {
    }

    public void setMode(String path, short mode) throws IOException {
    }

    protected boolean copyObject(String src, String dst) {
        LOG.debug("Copying {} to {}", (Object)src, (Object)dst);
        try {
            this.mClient.copyObject(this.mBucketName, src, this.mBucketName, dst);
            return true;
        }
        catch (ServiceException e) {
            LOG.error("Failed to rename file {} to {}", new Object[]{src, dst, e});
            return false;
        }
    }

    public boolean createEmptyObject(String key) {
        try {
            ObjectMetadata objMeta = new ObjectMetadata();
            objMeta.setContentLength(0L);
            this.mClient.putObject(this.mBucketName, key, (InputStream)new ByteArrayInputStream(new byte[0]), objMeta);
            return true;
        }
        catch (ServiceException e) {
            LOG.error("Failed to create object: {}", (Object)key, (Object)e);
            return false;
        }
    }

    protected OutputStream createObject(String key) throws IOException {
        return new OSSOutputStream(this.mBucketName, key, this.mClient, this.mUfsConf.getList(PropertyKey.TMP_DIRS));
    }

    protected boolean deleteObject(String key) {
        try {
            this.mClient.deleteObject(this.mBucketName, key);
        }
        catch (ServiceException e) {
            LOG.error("Failed to delete {}", (Object)key, (Object)e);
            return false;
        }
        return true;
    }

    protected String getFolderSuffix() {
        return FOLDER_SUFFIX;
    }

    protected ObjectUnderFileSystem.ObjectListingChunk getObjectListingChunk(String key, boolean recursive) throws IOException {
        String delimiter = recursive ? "" : PATH_SEPARATOR;
        key = PathUtils.normalizePath((String)key, (String)PATH_SEPARATOR);
        key = key.equals(PATH_SEPARATOR) ? "" : key;
        ListObjectsRequest request = new ListObjectsRequest(this.mBucketName);
        request.setPrefix(key);
        request.setMaxKeys(Integer.valueOf(this.getListingChunkLength((AlluxioConfiguration)this.mUfsConf)));
        request.setDelimiter(delimiter);
        ObjectListing result = this.getObjectListingChunk(request);
        if (result != null) {
            return new OSSObjectListingChunk(request, result);
        }
        return null;
    }

    private ObjectListing getObjectListingChunk(ListObjectsRequest request) {
        ObjectListing result;
        try {
            result = this.mClient.listObjects(request);
        }
        catch (ServiceException e) {
            LOG.error("Failed to list path {}", (Object)request.getPrefix(), (Object)e);
            result = null;
        }
        return result;
    }

    protected ObjectUnderFileSystem.ObjectStatus getObjectStatus(String key) {
        try {
            ObjectMetadata meta = this.mClient.getObjectMetadata(this.mBucketName, key);
            if (meta == null) {
                return null;
            }
            Date lastModifiedDate = meta.getLastModified();
            Long lastModifiedTime = lastModifiedDate == null ? null : Long.valueOf(lastModifiedDate.getTime());
            return new ObjectUnderFileSystem.ObjectStatus((ObjectUnderFileSystem)this, key, meta.getETag(), meta.getContentLength(), lastModifiedTime);
        }
        catch (ServiceException e) {
            return null;
        }
    }

    protected ObjectUnderFileSystem.ObjectPermissions getPermissions() {
        return new ObjectUnderFileSystem.ObjectPermissions((ObjectUnderFileSystem)this, "", "", 511);
    }

    protected String getRootKey() {
        return "oss://" + this.mBucketName;
    }

    public static ClientBuilderConfiguration initializeOSSClientConfig(AlluxioConfiguration alluxioConf) {
        ClientBuilderConfiguration ossClientConf = new ClientBuilderConfiguration();
        ossClientConf.setConnectionTimeout((int)alluxioConf.getMs(PropertyKey.UNDERFS_OSS_CONNECT_TIMEOUT));
        ossClientConf.setSocketTimeout((int)alluxioConf.getMs(PropertyKey.UNDERFS_OSS_SOCKET_TIMEOUT));
        ossClientConf.setConnectionTTL(alluxioConf.getMs(PropertyKey.UNDERFS_OSS_CONNECT_TTL));
        ossClientConf.setMaxConnections(alluxioConf.getInt(PropertyKey.UNDERFS_OSS_CONNECT_MAX));
        ossClientConf.setMaxErrorRetry(alluxioConf.getInt(PropertyKey.UNDERFS_OSS_RETRY_MAX));
        return ossClientConf;
    }

    protected InputStream openObject(String key, OpenOptions options, RetryPolicy retryPolicy) throws IOException {
        try {
            return new OSSInputStream(this.mBucketName, key, this.mClient, options.getOffset(), retryPolicy, this.mUfsConf.getBytes(PropertyKey.UNDERFS_OBJECT_STORE_MULTI_RANGE_CHUNK_SIZE));
        }
        catch (ServiceException e) {
            throw new IOException(e.getMessage());
        }
    }

    public void close() throws IOException {
        super.close();
        this.mClientProvider.close();
    }

    private final class OSSObjectListingChunk
    implements ObjectUnderFileSystem.ObjectListingChunk {
        final ListObjectsRequest mRequest;
        final ObjectListing mResult;

        OSSObjectListingChunk(ListObjectsRequest request, ObjectListing result) throws IOException {
            this.mRequest = request;
            this.mResult = result;
            if (this.mResult == null) {
                throw new IOException("OSS listing result is null");
            }
        }

        public ObjectUnderFileSystem.ObjectStatus[] getObjectStatuses() {
            List objects = this.mResult.getObjectSummaries();
            ObjectUnderFileSystem.ObjectStatus[] ret = new ObjectUnderFileSystem.ObjectStatus[objects.size()];
            int i = 0;
            for (OSSObjectSummary obj : objects) {
                Date lastModifiedDate = obj.getLastModified();
                Long lastModifiedTime = lastModifiedDate == null ? null : Long.valueOf(lastModifiedDate.getTime());
                ret[i++] = new ObjectUnderFileSystem.ObjectStatus((ObjectUnderFileSystem)OSSUnderFileSystem.this, obj.getKey(), obj.getETag(), obj.getSize(), lastModifiedTime);
            }
            return ret;
        }

        public String[] getCommonPrefixes() {
            List res = this.mResult.getCommonPrefixes();
            return res.toArray(new String[0]);
        }

        public ObjectUnderFileSystem.ObjectListingChunk getNextChunk() throws IOException {
            if (this.mResult.isTruncated()) {
                this.mRequest.setMarker(this.mResult.getNextMarker());
                ObjectListing nextResult = OSSUnderFileSystem.this.mClient.listObjects(this.mRequest);
                if (nextResult != null) {
                    return new OSSObjectListingChunk(this.mRequest, nextResult);
                }
            }
            return null;
        }
    }
}

