/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.oss;

import alluxio.underfs.ContentHashable;
import alluxio.util.CommonUtils;
import alluxio.util.io.PathUtils;
import com.aliyun.oss.OSS;
import com.aliyun.oss.ServiceException;
import com.aliyun.oss.model.ObjectMetadata;
import com.google.common.base.Preconditions;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class OSSOutputStream
extends OutputStream
implements ContentHashable {
    private static final Logger LOG = LoggerFactory.getLogger(OSSOutputStream.class);
    private final String mBucketName;
    private final String mKey;
    private final File mFile;
    private final OSS mOssClient;
    private OutputStream mLocalOutputStream;
    private MessageDigest mHash;
    private AtomicBoolean mClosed = new AtomicBoolean(false);
    private String mContentHash;

    public OSSOutputStream(String bucketName, String key, OSS client, List<String> tmpDirs) throws IOException {
        Preconditions.checkArgument((bucketName != null && !bucketName.isEmpty() ? 1 : 0) != 0, (Object)"Bucket name must not be null or empty.");
        Preconditions.checkArgument((key != null && !key.isEmpty() ? 1 : 0) != 0, (Object)"OSS path must not be null or empty.");
        Preconditions.checkArgument((client != null ? 1 : 0) != 0, (Object)"OSSClient must not be null.");
        this.mBucketName = bucketName;
        this.mKey = key;
        this.mOssClient = client;
        this.mFile = new File(PathUtils.concatPath((Object)CommonUtils.getTmpDir(tmpDirs), (Object)UUID.randomUUID()));
        try {
            this.mHash = MessageDigest.getInstance("MD5");
            this.mLocalOutputStream = new BufferedOutputStream(new DigestOutputStream(new FileOutputStream(this.mFile), this.mHash));
        }
        catch (NoSuchAlgorithmException e) {
            LOG.warn("Algorithm not available for MD5 hash.", (Throwable)e);
            this.mHash = null;
            this.mLocalOutputStream = new BufferedOutputStream(new FileOutputStream(this.mFile));
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.mLocalOutputStream.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.mLocalOutputStream.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.mLocalOutputStream.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.mLocalOutputStream.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.mClosed.getAndSet(true)) {
            return;
        }
        this.mLocalOutputStream.close();
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(this.mFile));){
            ObjectMetadata objMeta = new ObjectMetadata();
            objMeta.setContentLength(this.mFile.length());
            if (this.mHash != null) {
                byte[] hashBytes = this.mHash.digest();
                objMeta.setContentMD5(new String(Base64.encodeBase64((byte[])hashBytes)));
            }
            this.mContentHash = this.mOssClient.putObject(this.mBucketName, this.mKey, (InputStream)in, objMeta).getETag();
        }
        catch (ServiceException e) {
            LOG.error("Failed to upload {}.", (Object)this.mKey);
            throw new IOException(e);
        }
        finally {
            if (!this.mFile.delete()) {
                LOG.error("Failed to delete temporary file @ {}", (Object)this.mFile.getPath());
            }
        }
    }

    public Optional<String> getContentHash() {
        return Optional.ofNullable(this.mContentHash);
    }
}

