/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.oss;

import alluxio.underfs.ObjectPositionReader;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.OSSObject;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class OSSPositionReader
extends ObjectPositionReader {
    protected final OSS mClient;

    public OSSPositionReader(OSS client, String bucketName, String path, long fileLength) {
        super(bucketName, path, fileLength);
        this.mClient = client;
    }

    protected InputStream openObjectInputStream(long position, int bytesToRead) throws IOException {
        OSSObject object;
        try {
            GetObjectRequest getObjectRequest = new GetObjectRequest(this.mBucketName, this.mPath);
            getObjectRequest.setRange(position, position + (long)bytesToRead - 1L);
            object = this.mClient.getObject(getObjectRequest);
        }
        catch (OSSException e) {
            String errorMessage = String.format("Failed to get object: %s bucket: %s", this.mPath, this.mBucketName);
            throw new IOException(errorMessage, e);
        }
        return object.getObjectContent();
    }
}

