/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.oss;

import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.underfs.ObjectLowLevelOutputStream;
import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.model.AbortMultipartUploadRequest;
import com.aliyun.oss.model.CompleteMultipartUploadRequest;
import com.aliyun.oss.model.InitiateMultipartUploadRequest;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PartETag;
import com.aliyun.oss.model.PutObjectRequest;
import com.aliyun.oss.model.UploadPartRequest;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class OSSLowLevelOutputStream
extends ObjectLowLevelOutputStream {
    private final OSS mClient;
    private final List<PartETag> mTags = Collections.synchronizedList(new ArrayList());
    protected volatile String mUploadId;
    private String mContentHash;

    public OSSLowLevelOutputStream(String bucketName, String key, OSS oss, ListeningExecutorService executor, AlluxioConfiguration ufsConf) {
        super(bucketName, key, executor, ufsConf.getBytes(PropertyKey.UNDERFS_OSS_STREAMING_UPLOAD_PARTITION_SIZE), ufsConf);
        this.mClient = oss;
    }

    protected void abortMultiPartUploadInternal() throws IOException {
        try {
            this.getClient().abortMultipartUpload(new AbortMultipartUploadRequest(this.mBucketName, this.mKey, this.mUploadId));
        }
        catch (ClientException | OSSException e) {
            throw new IOException(e);
        }
    }

    protected void uploadPartInternal(File file, int partNumber, boolean isLastPart, String md5) throws IOException {
        try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));){
            UploadPartRequest uploadRequest = new UploadPartRequest(this.mBucketName, this.mKey, this.mUploadId, partNumber, (InputStream)inputStream, file.length());
            if (md5 != null) {
                uploadRequest.setMd5Digest(md5);
            }
            PartETag partETag = this.getClient().uploadPart(uploadRequest).getPartETag();
            this.mTags.add(partETag);
        }
        catch (ClientException | OSSException e) {
            throw new IOException(e);
        }
    }

    protected void initMultiPartUploadInternal() throws IOException {
        try {
            ObjectMetadata meta = new ObjectMetadata();
            meta.setContentType("application/octet-stream");
            InitiateMultipartUploadRequest initRequest = new InitiateMultipartUploadRequest(this.mBucketName, this.mKey, meta);
            this.mUploadId = this.getClient().initiateMultipartUpload(initRequest).getUploadId();
        }
        catch (ClientException | OSSException e) {
            throw new IOException(e);
        }
    }

    protected void completeMultiPartUploadInternal() throws IOException {
        try {
            CompleteMultipartUploadRequest completeRequest = new CompleteMultipartUploadRequest(this.mBucketName, this.mKey, this.mUploadId, this.mTags);
            this.mContentHash = this.getClient().completeMultipartUpload(completeRequest).getETag();
        }
        catch (ClientException | OSSException e) {
            throw new IOException(e);
        }
    }

    protected void createEmptyObject(String key) throws IOException {
        try {
            ObjectMetadata objMeta = new ObjectMetadata();
            objMeta.setContentLength(0L);
            this.mContentHash = this.getClient().putObject(this.mBucketName, key, (InputStream)new ByteArrayInputStream(new byte[0]), objMeta).getETag();
        }
        catch (ClientException | OSSException e) {
            throw new IOException(e);
        }
    }

    protected void putObject(String key, File file, String md5) throws IOException {
        try {
            ObjectMetadata objMeta = new ObjectMetadata();
            if (md5 != null) {
                objMeta.setContentMD5(md5);
            }
            PutObjectRequest request = new PutObjectRequest(this.mBucketName, key, file, objMeta);
            this.mContentHash = this.getClient().putObject(request).getETag();
        }
        catch (ClientException | OSSException e) {
            throw new IOException(e);
        }
    }

    public Optional<String> getContentHash() {
        return Optional.ofNullable(this.mContentHash);
    }

    protected OSS getClient() {
        return this.mClient;
    }
}

