/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.oss;

import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.retry.ExponentialBackoffRetry;
import alluxio.underfs.UnderFileSystemConfiguration;
import alluxio.underfs.oss.OSSUnderFileSystem;
import alluxio.util.ThreadFactoryUtils;
import alluxio.util.network.HttpUtils;
import com.aliyun.oss.ClientBuilderConfiguration;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.common.auth.Credentials;
import com.aliyun.oss.common.auth.DefaultCredentials;
import com.google.common.annotations.VisibleForTesting;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.Closeable;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StsOssClientProvider
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(StsOssClientProvider.class);
    private static final int ECS_META_GET_TIMEOUT = 10000;
    private static final int BASE_SLEEP_TIME_MS = 1000;
    private static final int MAX_SLEEP_MS = 3000;
    private static final int MAX_RETRIES = 5;
    private static final String ACCESS_KEY_ID = "AccessKeyId";
    private static final String ACCESS_KEY_SECRET = "AccessKeySecret";
    private static final String SECURITY_TOKEN = "SecurityToken";
    private static final String EXPIRATION = "Expiration";
    private volatile OSS mOssClient = null;
    private long mStsTokenExpiration = 0L;
    private final String mEcsMetadataServiceUrl;
    private final long mTokenTimeoutMs;
    private final UnderFileSystemConfiguration mOssConf;
    private final ScheduledExecutorService mRefreshOssClientScheduledThread;
    private OSSClientBuilder mOssClientBuilder = new OSSClientBuilder();

    public StsOssClientProvider(UnderFileSystemConfiguration ossConfiguration) {
        this.mOssConf = ossConfiguration;
        this.mEcsMetadataServiceUrl = ossConfiguration.getString(PropertyKey.UNDERFS_OSS_STS_ECS_METADATA_SERVICE_ENDPOINT);
        this.mTokenTimeoutMs = ossConfiguration.getMs(PropertyKey.UNDERFS_OSS_STS_TOKEN_REFRESH_INTERVAL_MS);
        this.mRefreshOssClientScheduledThread = Executors.newSingleThreadScheduledExecutor(ThreadFactoryUtils.build((String)"refresh_oss_client-%d", (boolean)false));
        this.mRefreshOssClientScheduledThread.scheduleAtFixedRate(() -> {
            try {
                this.createOrRefreshOssStsClient(this.mOssConf);
            }
            catch (Exception e) {
                LOG.warn("exception when refreshing OSS client access token", (Throwable)e);
            }
        }, 0L, 60000L, TimeUnit.MILLISECONDS);
    }

    public void init() throws IOException {
        ExponentialBackoffRetry retryPolicy = new ExponentialBackoffRetry(1000, 3000, 5);
        IOException lastException = null;
        while (retryPolicy.attempt()) {
            try {
                this.createOrRefreshOssStsClient(this.mOssConf);
                lastException = null;
                break;
            }
            catch (IOException e) {
                LOG.warn("init oss client failed! has retried {} times", (Object)retryPolicy.getAttemptCount(), (Object)e);
                lastException = e;
            }
        }
        if (lastException != null) {
            LOG.error("init oss client failed.", lastException);
            throw lastException;
        }
    }

    protected void createOrRefreshOssStsClient(UnderFileSystemConfiguration ossConfiguration) throws IOException {
        ClientBuilderConfiguration ossClientConf = OSSUnderFileSystem.initializeOSSClientConfig((AlluxioConfiguration)ossConfiguration);
        this.doCreateOrRefreshStsOssClient(ossConfiguration, ossClientConf);
    }

    boolean tokenWillExpiredAfter(long after) {
        return this.mStsTokenExpiration - System.currentTimeMillis() <= after;
    }

    private void doCreateOrRefreshStsOssClient(UnderFileSystemConfiguration ossConfiguration, ClientBuilderConfiguration clientConfiguration) throws IOException {
        if (this.tokenWillExpiredAfter(this.mTokenTimeoutMs)) {
            String ecsRamRole = ossConfiguration.getString(PropertyKey.UNDERFS_OSS_ECS_RAM_ROLE);
            String fullECSMetaDataServiceUrl = this.mEcsMetadataServiceUrl + ecsRamRole;
            String jsonStringResponse = HttpUtils.get((String)fullECSMetaDataServiceUrl, (Integer)10000);
            JsonObject jsonObject = (JsonObject)new Gson().fromJson(jsonStringResponse, JsonObject.class);
            String accessKeyId = jsonObject.get(ACCESS_KEY_ID).getAsString();
            String accessKeySecret = jsonObject.get(ACCESS_KEY_SECRET).getAsString();
            String securityToken = jsonObject.get(SECURITY_TOKEN).getAsString();
            this.mStsTokenExpiration = this.convertStringToDate(jsonObject.get(EXPIRATION).getAsString()).getTime();
            if (null == this.mOssClient) {
                this.mOssClient = this.mOssClientBuilder.build(ossConfiguration.getString(PropertyKey.OSS_ENDPOINT_KEY), accessKeyId, accessKeySecret, securityToken, clientConfiguration);
            } else {
                this.mOssClient.switchCredentials((Credentials)new DefaultCredentials(accessKeyId, accessKeySecret, securityToken));
            }
            LOG.debug("oss sts client create success, expiration = {}", (Object)this.mStsTokenExpiration);
        }
    }

    public OSS getOSSClient() {
        return this.mOssClient;
    }

    private Date convertStringToDate(String dateString) throws IOException {
        TimeZone zeroTimeZone = TimeZone.getTimeZone("ETC/GMT-0");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        sdf.setTimeZone(zeroTimeZone);
        Date date = null;
        try {
            date = sdf.parse(dateString);
        }
        catch (ParseException e) {
            throw new IOException(String.format("failed to parse date: %s", dateString), e);
        }
        return date;
    }

    @Override
    public void close() throws IOException {
        if (null != this.mRefreshOssClientScheduledThread) {
            this.mRefreshOssClientScheduledThread.shutdown();
        }
        if (null != this.mOssClient) {
            this.mOssClient.shutdown();
            this.mOssClient = null;
        }
    }

    @VisibleForTesting
    protected void setOssClientBuilder(OSSClientBuilder ossClientBuilder) {
        this.mOssClientBuilder = ossClientBuilder;
    }
}

