/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.ozone;

import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.underfs.UnderFileSystemConfiguration;
import alluxio.underfs.hdfs.HdfsUnderFileSystemFactory;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class OzoneUnderFileSystemFactory
extends HdfsUnderFileSystemFactory {
    public boolean supportsPath(String path) {
        List prefixes = Configuration.global().getList(PropertyKey.UNDERFS_OZONE_PREFIXES);
        if (path != null) {
            for (String prefix : prefixes) {
                if (!path.startsWith(prefix)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean supportsPath(String path, UnderFileSystemConfiguration conf) {
        return this.supportsPath(path) && (!conf.isSetByUser(PropertyKey.UNDERFS_VERSION) || conf.get(PropertyKey.UNDERFS_VERSION).equals(this.getVersion()));
    }

    public String getVersion() {
        return "1.2.1";
    }
}

