/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.ozone;

import alluxio.AlluxioURI;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.underfs.UnderFileSystem;
import alluxio.underfs.UnderFileSystemConfiguration;
import alluxio.underfs.hdfs.HdfsUnderFileSystemFactory;
import alluxio.underfs.ozone.OzoneUnderFileSystem;
import com.google.common.base.Preconditions;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class OzoneUnderFileSystemFactory
extends HdfsUnderFileSystemFactory {
    public UnderFileSystem create(String path, UnderFileSystemConfiguration conf) {
        Preconditions.checkNotNull((Object)path, (Object)"path");
        return OzoneUnderFileSystem.createInstance(new AlluxioURI(path), conf);
    }

    public boolean supportsPath(String path) {
        List prefixes = Configuration.global().getList(PropertyKey.UNDERFS_OZONE_PREFIXES);
        if (path != null) {
            for (String prefix : prefixes) {
                if (!path.startsWith(prefix)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean supportsPath(String path, UnderFileSystemConfiguration conf) {
        return this.supportsPath(path) && (!conf.isSetByUser(PropertyKey.UNDERFS_VERSION) || conf.get(PropertyKey.UNDERFS_VERSION).equals(this.getVersion()));
    }

    public String getVersion() {
        return "1.2.1";
    }
}

