/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.s3;

import alluxio.org.jets3t.service.S3Service;
import alluxio.org.jets3t.service.ServiceException;
import alluxio.org.jets3t.service.model.S3Object;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class S3InputStream
extends InputStream {
    private final String mBucketName;
    private final String mKey;
    private final S3Service mClient;
    private S3Object mObject;
    private BufferedInputStream mInputStream;
    private long mPos;

    S3InputStream(String bucketName, String key, S3Service client) throws ServiceException {
        this.mBucketName = bucketName;
        this.mKey = key;
        this.mClient = client;
        this.mObject = this.mClient.getObject(this.mBucketName, this.mKey);
        this.mInputStream = new BufferedInputStream(this.mObject.getDataInputStream());
    }

    @Override
    public void close() throws IOException {
        this.mInputStream.close();
    }

    @Override
    public int read() throws IOException {
        int ret = this.mInputStream.read();
        if (ret != -1) {
            ++this.mPos;
        }
        return ret;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int ret = this.mInputStream.read(b, off, len);
        if (ret != -1) {
            this.mPos += (long)ret;
        }
        return ret;
    }

    @Override
    public long skip(long n) throws IOException {
        if ((long)this.mInputStream.available() >= n) {
            return this.mInputStream.skip(n);
        }
        this.mInputStream.close();
        this.mPos += n;
        try {
            this.mObject = this.mClient.getObject(this.mBucketName, this.mKey, null, null, null, null, (Long)this.mPos, null);
            this.mInputStream = new BufferedInputStream(this.mObject.getDataInputStream());
        }
        catch (ServiceException e) {
            throw new IOException(e);
        }
        return n;
    }
}

