/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.s3;

import alluxio.Configuration;
import alluxio.org.jets3t.service.Jets3tProperties;
import alluxio.org.jets3t.service.S3Service;
import alluxio.org.jets3t.service.ServiceException;
import alluxio.org.jets3t.service.impl.rest.httpclient.RestS3Service;
import alluxio.org.jets3t.service.model.S3Object;
import alluxio.org.jets3t.service.model.StorageObject;
import alluxio.org.jets3t.service.security.AWSCredentials;
import alluxio.underfs.UnderFileSystem;
import alluxio.underfs.s3.S3InputStream;
import alluxio.underfs.s3.S3OutputStream;
import alluxio.util.io.PathUtils;
import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class S3UnderFileSystem
extends UnderFileSystem {
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");
    private static final String FOLDER_SUFFIX = "_$folder$";
    private static final String PATH_SEPARATOR = "/";
    private static final byte[] DIR_HASH;
    private final S3Service mClient;
    private final String mBucketName;
    private final String mBucketPrefix;

    public S3UnderFileSystem(String bucketName, Configuration conf) throws ServiceException {
        super(conf);
        Preconditions.checkArgument((boolean)conf.containsKey("fs.s3n.awsAccessKeyId"), (Object)"Property fs.s3n.awsAccessKeyId is required to connect to S3");
        Preconditions.checkArgument((boolean)conf.containsKey("fs.s3n.awsSecretAccessKey"), (Object)"Property fs.s3n.awsSecretAccessKey is required to connect to S3");
        AWSCredentials awsCredentials = new AWSCredentials(conf.get("fs.s3n.awsAccessKeyId"), conf.get("fs.s3n.awsSecretAccessKey"));
        this.mBucketName = bucketName;
        Jets3tProperties props = new Jets3tProperties();
        if (conf.containsKey("alluxio.underfs.s3.proxy.host")) {
            props.setProperty("httpclient.proxy-autodetect", "false");
            props.setProperty("httpclient.proxy-host", conf.get("alluxio.underfs.s3.proxy.host"));
            props.setProperty("httpclient.proxy-port", conf.get("alluxio.underfs.s3.proxy.port"));
        }
        if (conf.containsKey("alluxio.underfs.s3.proxy.https.only")) {
            props.setProperty("s3service.https-only", Boolean.toString(conf.getBoolean("alluxio.underfs.s3.proxy.https.only")));
        }
        LOG.debug("Initializing S3 underFs with properties: {}", (Object)props.getProperties());
        this.mClient = new RestS3Service(awsCredentials, null, null, props);
        this.mBucketPrefix = "s3n://" + this.mBucketName + PATH_SEPARATOR;
    }

    public UnderFileSystem.UnderFSType getUnderFSType() {
        return UnderFileSystem.UnderFSType.S3;
    }

    public void close() throws IOException {
    }

    public void connectFromMaster(Configuration conf, String hostname) {
    }

    public void connectFromWorker(Configuration conf, String hostname) {
    }

    public OutputStream create(String path) throws IOException {
        if (this.mkdirs(this.getParentKey(path), true)) {
            return new S3OutputStream(this.mBucketName, this.stripPrefixIfPresent(path), this.mClient);
        }
        return null;
    }

    public OutputStream create(String path, int blockSizeByte) throws IOException {
        LOG.warn("Create with block size is not supported with S3UnderFileSystem. Block size will be ignored.");
        return this.create(path);
    }

    public OutputStream create(String path, short replication, int blockSizeByte) throws IOException {
        LOG.warn("Create with block size and replication is not supported with S3UnderFileSystem. Block size and replication will be ignored.");
        return this.create(path);
    }

    public boolean delete(String path, boolean recursive) throws IOException {
        String[] pathsToDelete;
        if (!recursive) {
            if (this.isFolder(path) && this.listInternal(path, false).length != 0) {
                LOG.error("Unable to delete " + path + " because it is a non empty directory. Specify " + "recursive as true in order to delete non empty directories.");
                return false;
            }
            return this.deleteInternal(path);
        }
        for (String pathToDelete : pathsToDelete = this.listInternal(path, true)) {
            if (this.deleteInternal(PathUtils.concatPath((Object)path, (Object[])new Object[]{pathToDelete}))) continue;
            LOG.error("Failed to delete path {}, aborting delete.", (Object)pathToDelete);
            return false;
        }
        return this.deleteInternal(path);
    }

    public boolean exists(String path) throws IOException {
        return this.isRoot(path) || this.getObjectDetails(path) != null;
    }

    public long getBlockSizeByte(String path) throws IOException {
        return 0x50000000000L;
    }

    public Object getConf() {
        LOG.warn("getConf is not supported when using S3UnderFileSystem, returning null.");
        return null;
    }

    public List<String> getFileLocations(String path) throws IOException {
        LOG.warn("getFileLocations is not supported when using S3UnderFileSystem, returning null.");
        return null;
    }

    public List<String> getFileLocations(String path, long offset) throws IOException {
        LOG.warn("getFileLocations is not supported when using S3UnderFileSystem, returning null.");
        return null;
    }

    public long getFileSize(String path) throws IOException {
        StorageObject details = this.getObjectDetails(path);
        if (details != null) {
            return details.getContentLength();
        }
        throw new FileNotFoundException(path);
    }

    public long getModificationTimeMs(String path) throws IOException {
        StorageObject details = this.getObjectDetails(path);
        if (details != null) {
            return details.getLastModifiedDate().getTime();
        }
        throw new FileNotFoundException(path);
    }

    public long getSpace(String path, UnderFileSystem.SpaceType type) throws IOException {
        return -1L;
    }

    public boolean isFile(String path) throws IOException {
        return this.exists(path) && !this.isFolder(path);
    }

    public String[] list(String path) throws IOException {
        if (!this.exists(path) || this.isFile(path)) {
            return null;
        }
        path = path.endsWith(PATH_SEPARATOR) ? path : path + PATH_SEPARATOR;
        return this.listInternal(path, false);
    }

    public boolean mkdirs(String path, boolean createParent) throws IOException {
        if (path == null) {
            return false;
        }
        if (this.isFolder(path)) {
            return true;
        }
        if (this.exists(path)) {
            LOG.error("Cannot create directory {} because it is already a file.", (Object)path);
            return false;
        }
        if (!createParent) {
            if (this.parentExists(path)) {
                return this.mkdirsInternal(path);
            }
            LOG.error("Cannot create directory {} because parent does not exist", (Object)path);
            return false;
        }
        if (this.parentExists(path)) {
            return this.mkdirsInternal(path);
        }
        String parentKey = this.getParentKey(path);
        return this.mkdirs(parentKey, true) && this.mkdirsInternal(path);
    }

    public InputStream open(String path) throws IOException {
        try {
            path = this.stripPrefixIfPresent(path);
            return new S3InputStream(this.mBucketName, path, this.mClient);
        }
        catch (ServiceException e) {
            LOG.error("Failed to open file: {}", (Object)path, (Object)e);
            return null;
        }
    }

    public boolean rename(String src, String dst) throws IOException {
        if (!this.exists(src)) {
            LOG.error("Unable to rename {} to {} because source does not exist.", (Object)src, (Object)dst);
            return false;
        }
        if (this.exists(dst)) {
            LOG.error("Unable to rename {} to {} because destination already exists.", (Object)src, (Object)dst);
            return false;
        }
        if (this.isFolder(src)) {
            String[] children;
            if (!this.copy(this.convertToFolderName(src), this.convertToFolderName(dst))) {
                return false;
            }
            for (String child : children = this.list(src)) {
                if (this.rename(PathUtils.concatPath((Object)src, (Object[])new Object[]{child}), PathUtils.concatPath((Object)dst, (Object[])new Object[]{child}))) continue;
                return false;
            }
            return this.delete(src, true);
        }
        return this.copy(src, dst) && this.deleteInternal(src);
    }

    public void setConf(Object conf) {
    }

    public void setPermission(String path, String posixPerm) throws IOException {
    }

    private String convertToFolderName(String key) {
        if (key.endsWith(PATH_SEPARATOR)) {
            key = key.substring(0, key.length() - PATH_SEPARATOR.length());
        }
        return key + FOLDER_SUFFIX;
    }

    private boolean copy(String src, String dst) {
        try {
            src = this.stripPrefixIfPresent(src);
            dst = this.stripPrefixIfPresent(dst);
            LOG.info("Copying {} to {}", (Object)src, (Object)dst);
            S3Object obj = new S3Object(dst);
            this.mClient.copyObject(this.mBucketName, src, this.mBucketName, obj, false);
            return true;
        }
        catch (ServiceException e) {
            LOG.error("Failed to rename file {} to {}", new Object[]{src, dst, e});
            return false;
        }
    }

    private boolean deleteInternal(String key) {
        try {
            if (this.isFolder(key)) {
                String keyAsFolder = this.convertToFolderName(this.stripPrefixIfPresent(key));
                this.mClient.deleteObject(this.mBucketName, keyAsFolder);
            } else {
                this.mClient.deleteObject(this.mBucketName, this.stripPrefixIfPresent(key));
            }
        }
        catch (ServiceException e) {
            LOG.error("Failed to delete {}", (Object)key, (Object)e);
            return false;
        }
        return true;
    }

    private String getChildName(String child, String parent) {
        if (child.startsWith(parent)) {
            return child.substring(parent.length());
        }
        LOG.error("Attempted to get childname with an invalid parent argument. Parent: {} Child: {}", (Object)parent, (Object)child);
        return null;
    }

    private StorageObject getObjectDetails(String key) {
        try {
            if (this.isFolder(key)) {
                String keyAsFolder = this.convertToFolderName(this.stripPrefixIfPresent(key));
                return this.mClient.getObjectDetails(this.mBucketName, keyAsFolder);
            }
            return this.mClient.getObjectDetails(this.mBucketName, this.stripPrefixIfPresent(key));
        }
        catch (ServiceException e) {
            return null;
        }
    }

    private String getParentKey(String key) {
        if (this.isRoot(key)) {
            return null;
        }
        int separatorIndex = key.lastIndexOf(PATH_SEPARATOR);
        if (separatorIndex < 0) {
            return null;
        }
        return key.substring(0, separatorIndex);
    }

    private boolean isFolder(String key) {
        if (this.isRoot(key)) {
            return true;
        }
        try {
            String keyAsFolder = this.convertToFolderName(this.stripPrefixIfPresent(key));
            this.mClient.getObjectDetails(this.mBucketName, keyAsFolder);
            return true;
        }
        catch (ServiceException s) {
            try {
                String dir = this.stripPrefixIfPresent(key);
                String dirPrefix = dir.endsWith(PATH_SEPARATOR) ? dir : dir + PATH_SEPARATOR;
                S3Object[] objs = this.mClient.listObjects(this.mBucketName, dirPrefix, "");
                if (objs.length > 0) {
                    this.mkdirsInternal(dir);
                    return true;
                }
                return false;
            }
            catch (ServiceException s2) {
                return false;
            }
        }
    }

    private boolean isRoot(String key) {
        return key.equals("s3n://" + this.mBucketName) || key.equals("s3n://" + this.mBucketName + PATH_SEPARATOR);
    }

    private String[] listInternal(String path, boolean recursive) throws IOException {
        try {
            path = this.stripPrefixIfPresent(path);
            path = path.endsWith(PATH_SEPARATOR) ? path : path + PATH_SEPARATOR;
            path = path.equals(PATH_SEPARATOR) ? "" : path;
            S3Object[] objs = this.mClient.listObjects(this.mBucketName, path, "");
            if (recursive) {
                ArrayList<String> ret = new ArrayList<String>();
                for (S3Object obj : objs) {
                    String child = this.getChildName(obj.getKey(), path);
                    if ((child = this.stripFolderSuffixIfPresent(child)).isEmpty()) continue;
                    ret.add(child);
                }
                return ret.toArray(new String[ret.size()]);
            }
            HashSet<String> children = new HashSet<String>();
            for (S3Object obj : objs) {
                String child = this.getChildName(obj.getKey(), path);
                int childNameIndex = child.indexOf(PATH_SEPARATOR);
                child = childNameIndex != -1 ? child.substring(0, childNameIndex) : child;
                if ((child = this.stripFolderSuffixIfPresent(child)).isEmpty()) continue;
                children.add(child);
            }
            return children.toArray(new String[children.size()]);
        }
        catch (ServiceException e) {
            LOG.error("Failed to list path {}", (Object)path, (Object)e);
            return null;
        }
    }

    private boolean mkdirsInternal(String key) {
        try {
            String keyAsFolder = this.convertToFolderName(this.stripPrefixIfPresent(key));
            S3Object obj = new S3Object(keyAsFolder);
            obj.setDataInputStream(new ByteArrayInputStream(new byte[0]));
            obj.setContentLength(0L);
            obj.setMd5Hash(DIR_HASH);
            obj.setContentType("binary/octet-stream");
            this.mClient.putObject(this.mBucketName, obj);
            return true;
        }
        catch (ServiceException e) {
            LOG.error("Failed to create directory: {}", (Object)key, (Object)e);
            return false;
        }
    }

    private boolean parentExists(String key) {
        if (this.isRoot(key)) {
            return true;
        }
        String parentKey = this.getParentKey(key);
        return parentKey != null && this.isFolder(parentKey);
    }

    private String stripFolderSuffixIfPresent(String key) {
        if (key.endsWith(FOLDER_SUFFIX)) {
            return key.substring(0, key.length() - FOLDER_SUFFIX.length());
        }
        return key;
    }

    private String stripPrefixIfPresent(String key) {
        if (key.startsWith(this.mBucketPrefix)) {
            return key.substring(this.mBucketPrefix.length());
        }
        if (key.startsWith(PATH_SEPARATOR)) {
            return key.substring(PATH_SEPARATOR.length());
        }
        return key;
    }

    static {
        try {
            DIR_HASH = MessageDigest.getInstance("MD5").digest(new byte[0]);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }
}

