/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.s3;

import alluxio.AlluxioURI;
import alluxio.Configuration;
import alluxio.org.jets3t.service.ServiceException;
import alluxio.underfs.UnderFileSystem;
import alluxio.underfs.UnderFileSystemFactory;
import alluxio.underfs.s3.S3UnderFileSystem;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.IOException;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class S3UnderFileSystemFactory
implements UnderFileSystemFactory {
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");

    public UnderFileSystem create(String path, Configuration configuration, Object unusedConf) {
        Preconditions.checkNotNull((Object)path);
        Preconditions.checkNotNull((Object)configuration);
        if (this.addAndCheckAWSCredentials(configuration)) {
            try {
                return new S3UnderFileSystem(new AlluxioURI(path), configuration);
            }
            catch (ServiceException e) {
                LOG.error("Failed to create S3UnderFileSystem.", (Throwable)e);
                throw Throwables.propagate((Throwable)e);
            }
        }
        String err = "AWS Credentials not available, cannot create S3 Under File System.";
        LOG.error(err);
        throw Throwables.propagate((Throwable)new IOException(err));
    }

    public boolean supportsPath(String path, Configuration configuration) {
        return path != null && path.startsWith("s3n://");
    }

    private boolean addAndCheckAWSCredentials(Configuration configuration) {
        String secretKeyConf;
        String accessKeyConf = "fs.s3n.awsAccessKeyId";
        if (System.getProperty(accessKeyConf) != null && configuration.get(accessKeyConf) == null) {
            configuration.set(accessKeyConf, System.getProperty(accessKeyConf));
        }
        if (System.getProperty(secretKeyConf = "fs.s3n.awsSecretAccessKey") != null && configuration.get(secretKeyConf) == null) {
            configuration.set(secretKeyConf, System.getProperty(secretKeyConf));
        }
        return configuration.get(accessKeyConf) != null && configuration.get(secretKeyConf) != null;
    }
}

