/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.tos;

import alluxio.exception.runtime.AlluxioRuntimeException;
import alluxio.grpc.ErrorType;
import com.google.protobuf.Any;
import com.volcengine.tos.TosClientException;
import io.grpc.Status;

public class AlluxioTosException
extends AlluxioRuntimeException {
    private static final ErrorType ERROR_TYPE = ErrorType.External;

    public static AlluxioTosException from(TosClientException cause) {
        return AlluxioTosException.from(null, cause);
    }

    public static AlluxioTosException from(String errorMessage, TosClientException cause) {
        Status status = Status.UNKNOWN;
        String errorDescription = "ClientException:" + cause.getMessage();
        status = AlluxioTosException.httpStatusToGrpcStatus(cause.getStatusCode());
        errorDescription = cause.getCode() + ":" + cause.getMessage();
        if (errorMessage == null) {
            errorMessage = errorDescription;
        }
        return new AlluxioTosException(status, errorMessage, (Throwable)cause, true);
    }

    private AlluxioTosException(Status status, String message, Throwable cause, boolean isRetryAble) {
        super(status, message, cause, ERROR_TYPE, isRetryAble, new Any[0]);
    }

    private static Status httpStatusToGrpcStatus(int httpStatusCode) {
        if (httpStatusCode >= 100 && httpStatusCode < 200) {
            return Status.INTERNAL;
        }
        switch (httpStatusCode) {
            case 400: {
                return Status.INVALID_ARGUMENT;
            }
            case 401: {
                return Status.UNAUTHENTICATED;
            }
            case 403: {
                return Status.PERMISSION_DENIED;
            }
            case 404: {
                return Status.NOT_FOUND;
            }
            case 405: 
            case 501: {
                return Status.UNIMPLEMENTED;
            }
            case 409: {
                return Status.ABORTED;
            }
            case 411: 
            case 412: {
                return Status.FAILED_PRECONDITION;
            }
            case 416: {
                return Status.OUT_OF_RANGE;
            }
            case 500: {
                return Status.INTERNAL;
            }
            case 301: 
            case 304: 
            case 307: 
            case 502: 
            case 503: {
                return Status.UNAVAILABLE;
            }
            case 504: {
                return Status.DEADLINE_EXCEEDED;
            }
        }
        return Status.UNKNOWN;
    }
}

