/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.tos;

import alluxio.AlluxioURI;
import alluxio.conf.PropertyKey;
import alluxio.retry.RetryPolicy;
import alluxio.underfs.ObjectUnderFileSystem;
import alluxio.underfs.UnderFileSystemConfiguration;
import alluxio.underfs.options.OpenOptions;
import alluxio.underfs.tos.AlluxioTosException;
import alluxio.underfs.tos.TOSInputStream;
import alluxio.underfs.tos.TOSOutputStream;
import alluxio.util.UnderFileSystemUtils;
import alluxio.util.io.PathUtils;
import com.google.common.base.Preconditions;
import com.volcengine.tos.TOSV2;
import com.volcengine.tos.TOSV2ClientBuilder;
import com.volcengine.tos.TosClientException;
import com.volcengine.tos.TosException;
import com.volcengine.tos.TosServerException;
import com.volcengine.tos.model.object.CopyObjectV2Input;
import com.volcengine.tos.model.object.CopyObjectV2Output;
import com.volcengine.tos.model.object.DeleteMultiObjectsV2Input;
import com.volcengine.tos.model.object.DeleteMultiObjectsV2Output;
import com.volcengine.tos.model.object.DeleteObjectInput;
import com.volcengine.tos.model.object.DeleteObjectOutput;
import com.volcengine.tos.model.object.Deleted;
import com.volcengine.tos.model.object.HeadObjectV2Input;
import com.volcengine.tos.model.object.HeadObjectV2Output;
import com.volcengine.tos.model.object.ListObjectsType2Input;
import com.volcengine.tos.model.object.ListObjectsType2Output;
import com.volcengine.tos.model.object.ListedCommonPrefix;
import com.volcengine.tos.model.object.ListedObjectV2;
import com.volcengine.tos.model.object.ObjectMetaRequestOptions;
import com.volcengine.tos.model.object.ObjectTobeDeleted;
import com.volcengine.tos.model.object.PutObjectInput;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class TOSUnderFileSystem
extends ObjectUnderFileSystem {
    private static final Logger LOG = LoggerFactory.getLogger(TOSUnderFileSystem.class);
    private static final String FOLDER_SUFFIX = "/";
    private final TOSV2 mClient;
    private final String mBucketName;

    public static TOSUnderFileSystem createInstance(AlluxioURI uri, UnderFileSystemConfiguration conf) throws Exception {
        String bucketName = UnderFileSystemUtils.getBucketName((AlluxioURI)uri);
        Preconditions.checkArgument((boolean)conf.isSet(PropertyKey.TOS_ACCESS_KEY), (String)"Property %s is required to connect to TOS", (Object)PropertyKey.TOS_ACCESS_KEY);
        Preconditions.checkArgument((boolean)conf.isSet(PropertyKey.TOS_SECRET_KEY), (String)"Property %s is required to connect to TOS", (Object)PropertyKey.TOS_SECRET_KEY);
        Preconditions.checkArgument((boolean)conf.isSet(PropertyKey.TOS_REGION), (String)"Property %s is required to connect to TOS", (Object)PropertyKey.TOS_REGION);
        Preconditions.checkArgument((boolean)conf.isSet(PropertyKey.TOS_ENDPOINT_KEY), (String)"Property %s is required to connect to TOS", (Object)PropertyKey.TOS_ENDPOINT_KEY);
        String accessKey = conf.getString(PropertyKey.TOS_ACCESS_KEY);
        String secretKey = conf.getString(PropertyKey.TOS_SECRET_KEY);
        String regionName = conf.getString(PropertyKey.TOS_REGION);
        String endPoint = conf.getString(PropertyKey.TOS_ENDPOINT_KEY);
        TOSV2 tos = new TOSV2ClientBuilder().build(regionName, endPoint, accessKey, secretKey);
        return new TOSUnderFileSystem(uri, tos, bucketName, conf);
    }

    protected TOSUnderFileSystem(AlluxioURI uri, @Nullable TOSV2 tosClient, String bucketName, UnderFileSystemConfiguration conf) {
        super(uri, conf);
        this.mClient = tosClient;
        this.mBucketName = bucketName;
    }

    public String getUnderFSType() {
        return "tos";
    }

    public void setOwner(String path, String user, String group) {
    }

    public void setMode(String path, short mode) throws IOException {
    }

    protected boolean copyObject(String src, String dst) {
        LOG.debug("Copying {} to {}", (Object)src, (Object)dst);
        try {
            CopyObjectV2Input input = new CopyObjectV2Input().setBucket(this.mBucketName).setKey(dst).setSrcBucket(this.mBucketName).setSrcKey(src);
            CopyObjectV2Output output = this.mClient.copyObject(input);
            return true;
        }
        catch (TosException e) {
            LOG.error("Failed to rename file {} to {}", new Object[]{src, dst, e});
            return false;
        }
    }

    public boolean createEmptyObject(String key) {
        try {
            ObjectMetaRequestOptions metaRequestOptions = new ObjectMetaRequestOptions();
            metaRequestOptions.setContentLength(0L);
            ByteArrayInputStream stream = new ByteArrayInputStream(new byte[0]);
            PutObjectInput input = new PutObjectInput().setBucket(this.mBucketName).setKey(key).setOptions(metaRequestOptions).setContent((InputStream)stream);
            this.mClient.putObject(input);
            return true;
        }
        catch (TosException e) {
            LOG.error("Failed to create object: {}", (Object)key, (Object)e);
            return false;
        }
    }

    protected OutputStream createObject(String key) throws IOException {
        return new TOSOutputStream(this.mBucketName, key, this.mClient, this.mUfsConf.getList(PropertyKey.TMP_DIRS));
    }

    protected boolean deleteObject(String key) {
        try {
            DeleteObjectInput input = new DeleteObjectInput().setBucket(this.mBucketName).setKey(key);
            DeleteObjectOutput deleteObjectOutput = this.mClient.deleteObject(input);
        }
        catch (TosException e) {
            LOG.error("Failed to delete {}", (Object)key, (Object)e);
            return false;
        }
        return true;
    }

    protected List<String> deleteObjects(List<String> keys) throws IOException {
        try {
            ArrayList<ObjectTobeDeleted> list = new ArrayList<ObjectTobeDeleted>();
            for (String key : keys) {
                list.add(new ObjectTobeDeleted().setKey(key));
            }
            DeleteMultiObjectsV2Input input = new DeleteMultiObjectsV2Input().setBucket(this.mBucketName).setObjects(list);
            DeleteMultiObjectsV2Output output = this.mClient.deleteMultiObjects(input);
            return output.getDeleteds().stream().map(Deleted::getKey).collect(Collectors.toList());
        }
        catch (TosException e) {
            throw new IOException("Failed to delete objects", e);
        }
    }

    protected String getFolderSuffix() {
        return FOLDER_SUFFIX;
    }

    protected ObjectUnderFileSystem.ObjectListingChunk getObjectListingChunk(String key, boolean recursive) throws IOException {
        String delimiter = recursive ? "" : PATH_SEPARATOR;
        key = PathUtils.normalizePath((String)key, (String)PATH_SEPARATOR);
        key = key.equals(PATH_SEPARATOR) ? "" : key;
        ListObjectsType2Input input = new ListObjectsType2Input().setBucket(this.mBucketName).setDelimiter(delimiter).setPrefix(key);
        ListObjectsType2Output output = this.getObjectListingChunk(input);
        if (output != null) {
            return new TOSObjectListingChunk(input, output);
        }
        return null;
    }

    private ListObjectsType2Output getObjectListingChunk(ListObjectsType2Input input) {
        ListObjectsType2Output result;
        try {
            result = this.mClient.listObjectsType2(input);
        }
        catch (TosException e) {
            LOG.error("Failed to list path {}", (Object)input.getPrefix(), (Object)e);
            result = null;
        }
        return result;
    }

    protected ObjectUnderFileSystem.ObjectStatus getObjectStatus(String key) {
        try {
            HeadObjectV2Input input = new HeadObjectV2Input().setBucket(this.mBucketName).setKey(key);
            HeadObjectV2Output output = this.mClient.headObject(input);
            if (output == null) {
                return null;
            }
            Date lastModifiedDate = output.getLastModifiedInDate();
            Long lastModifiedTime = lastModifiedDate == null ? null : Long.valueOf(lastModifiedDate.getTime());
            return new ObjectUnderFileSystem.ObjectStatus(key, output.getEtag(), output.getContentLength(), lastModifiedTime);
        }
        catch (TosServerException e) {
            if (e.getStatusCode() == 404) {
                return null;
            }
            throw AlluxioTosException.from((RuntimeException)((Object)e));
        }
        catch (TosClientException e) {
            throw AlluxioTosException.from(e);
        }
    }

    protected ObjectUnderFileSystem.ObjectPermissions getPermissions() {
        return new ObjectUnderFileSystem.ObjectPermissions("", "", 511);
    }

    protected String getRootKey() {
        return "tos://" + this.mBucketName;
    }

    protected InputStream openObject(String key, OpenOptions options, RetryPolicy retryPolicy) throws IOException {
        try {
            return new TOSInputStream(this.mBucketName, key, this.mClient, options.getOffset(), retryPolicy, this.mUfsConf.getBytes(PropertyKey.UNDERFS_OBJECT_STORE_MULTI_RANGE_CHUNK_SIZE));
        }
        catch (TosException e) {
            throw AlluxioTosException.from((RuntimeException)((Object)e));
        }
    }

    public void close() throws IOException {
        super.close();
        this.mClient.close();
    }

    private final class TOSObjectListingChunk
    implements ObjectUnderFileSystem.ObjectListingChunk {
        final ListObjectsType2Input mInput;
        final ListObjectsType2Output mOutput;

        TOSObjectListingChunk(ListObjectsType2Input Input, ListObjectsType2Output Output) throws IOException {
            this.mInput = Input;
            this.mOutput = Output;
            if (this.mOutput == null) {
                throw new IOException("TOS listing result is null");
            }
        }

        public ObjectUnderFileSystem.ObjectStatus[] getObjectStatuses() {
            List objects = this.mOutput.getContents();
            if (objects == null) {
                return new ObjectUnderFileSystem.ObjectStatus[0];
            }
            ObjectUnderFileSystem.ObjectStatus[] ret = new ObjectUnderFileSystem.ObjectStatus[objects.size()];
            int i = 0;
            for (ListedObjectV2 obj : objects) {
                Date lastModifiedDate = obj.getLastModified();
                Long lastModifiedTime = lastModifiedDate == null ? null : Long.valueOf(lastModifiedDate.getTime());
                ret[i++] = new ObjectUnderFileSystem.ObjectStatus(obj.getKey(), obj.getEtag(), obj.getSize(), lastModifiedTime);
            }
            return ret;
        }

        public String[] getCommonPrefixes() {
            List res = this.mOutput.getCommonPrefixes();
            if (res == null) {
                return new String[0];
            }
            return (String[])res.stream().map(ListedCommonPrefix::getPrefix).toArray(String[]::new);
        }

        public ObjectUnderFileSystem.ObjectListingChunk getNextChunk() throws IOException {
            if (this.mOutput.isTruncated()) {
                this.mInput.setContinuationToken(this.mOutput.getNextContinuationToken());
                ListObjectsType2Output nextResult = TOSUnderFileSystem.this.mClient.listObjectsType2(this.mInput);
                if (nextResult != null) {
                    return new TOSObjectListingChunk(this.mInput, nextResult);
                }
            }
            return null;
        }

        public Boolean hasNextChunk() {
            return this.mOutput.isTruncated();
        }
    }
}

