/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.tos;

import alluxio.retry.RetryPolicy;
import alluxio.underfs.MultiRangeObjectInputStream;
import com.volcengine.tos.TOSV2;
import com.volcengine.tos.TosException;
import com.volcengine.tos.model.object.GetObjectV2Input;
import com.volcengine.tos.model.object.GetObjectV2Output;
import com.volcengine.tos.model.object.HeadObjectV2Input;
import com.volcengine.tos.model.object.HeadObjectV2Output;
import com.volcengine.tos.model.object.ObjectMetaRequestOptions;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class TOSInputStream
extends MultiRangeObjectInputStream {
    private static final Logger LOG = LoggerFactory.getLogger(TOSInputStream.class);
    private final String mBucketName;
    private final String mKey;
    private final TOSV2 mTosClient;
    private final long mContentLength;
    private final RetryPolicy mRetryPolicy;

    TOSInputStream(String bucketName, String key, TOSV2 client, RetryPolicy retryPolicy, long multiRangeChunkSize) throws IOException {
        this(bucketName, key, client, 0L, retryPolicy, multiRangeChunkSize);
    }

    TOSInputStream(String bucketName, String key, TOSV2 client, long position, RetryPolicy retryPolicy, long multiRangeChunkSize) throws IOException {
        super(multiRangeChunkSize);
        this.mBucketName = bucketName;
        this.mKey = key;
        this.mTosClient = client;
        this.mPos = position;
        this.mRetryPolicy = retryPolicy;
        HeadObjectV2Input input = new HeadObjectV2Input().setBucket(bucketName).setKey(key);
        HeadObjectV2Output meta = this.mTosClient.headObject(input);
        this.mContentLength = meta == null ? 0L : meta.getContentLength();
    }

    protected InputStream createStream(long startPos, long endPos) throws IOException {
        ObjectMetaRequestOptions options = new ObjectMetaRequestOptions();
        GetObjectV2Input req = new GetObjectV2Input().setBucket(this.mBucketName).setKey(this.mKey);
        options.setRange(startPos, endPos < this.mContentLength ? endPos - 1L : this.mContentLength - 1L);
        req.setOptions(options);
        TosException lastException = null;
        String errorMessage = String.format("Failed to open key: %s bucket: %s", this.mKey, this.mBucketName);
        RetryPolicy retryPolicy = this.mRetryPolicy.copy();
        while (retryPolicy.attempt()) {
            try {
                GetObjectV2Output object = this.mTosClient.getObject(req);
                return new BufferedInputStream(object.getContent());
            }
            catch (TosException e) {
                errorMessage = String.format("Failed to open key: %s bucket: %s attempts: %d error: %s", this.mKey, this.mBucketName, retryPolicy.getAttemptCount(), e.getMessage());
                if (e.getStatusCode() != 404) {
                    throw new IOException(errorMessage, e);
                }
                lastException = e;
            }
        }
        throw new IOException(errorMessage, lastException);
    }
}

