/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.tos;

import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.underfs.ObjectLowLevelOutputStream;
import alluxio.underfs.tos.AlluxioTosException;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.volcengine.tos.TOSV2;
import com.volcengine.tos.TosException;
import com.volcengine.tos.comm.io.TosRepeatableBoundedFileInputStream;
import com.volcengine.tos.model.object.AbortMultipartUploadInput;
import com.volcengine.tos.model.object.CompleteMultipartUploadV2Input;
import com.volcengine.tos.model.object.CompleteMultipartUploadV2Output;
import com.volcengine.tos.model.object.CreateMultipartUploadInput;
import com.volcengine.tos.model.object.CreateMultipartUploadOutput;
import com.volcengine.tos.model.object.PutObjectInput;
import com.volcengine.tos.model.object.UploadPartV2Input;
import com.volcengine.tos.model.object.UploadPartV2Output;
import com.volcengine.tos.model.object.UploadedPartV2;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class TOSLowLevelOutputStream
extends ObjectLowLevelOutputStream {
    private static final Logger LOG = LoggerFactory.getLogger(TOSLowLevelOutputStream.class);
    protected TOSV2 mClient;
    private final List<UploadedPartV2> mTags = Collections.synchronizedList(new ArrayList());
    protected volatile String mUploadId;
    private String mContentHash;

    public TOSLowLevelOutputStream(String bucketName, String key, TOSV2 tosClient, ListeningExecutorService executor, AlluxioConfiguration ufsConf) {
        super(bucketName, key, executor, ufsConf.getBytes(PropertyKey.UNDERFS_TOS_STREAMING_UPLOAD_PARTITION_SIZE), ufsConf);
        this.mClient = (TOSV2)Preconditions.checkNotNull((Object)tosClient);
    }

    protected void abortMultiPartUploadInternal() throws IOException {
        try {
            AbortMultipartUploadInput input = new AbortMultipartUploadInput().setBucket(this.mBucketName).setKey(this.mKey).setUploadID(this.mUploadId);
            this.getClient().abortMultipartUpload(input);
        }
        catch (TosException e) {
            LOG.debug("failed to abort multi part upload. upload id: {}", (Object)this.mUploadId, (Object)e);
            throw AlluxioTosException.from(String.format("failed to upload part. key: %s uploadId: %s", this.mKey, this.mUploadId), e);
        }
    }

    protected void uploadPartInternal(File file, int partNumber, boolean isLastPart, @Nullable String md5) throws IOException {
        long fileSize = file.length();
        long partSize = this.mPartitionSize;
        try (FileInputStream content = new FileInputStream(file);){
            TosRepeatableBoundedFileInputStream wrappedContent = new TosRepeatableBoundedFileInputStream(content, this.mPartitionSize);
            if (isLastPart) {
                partSize = fileSize;
            }
            UploadPartV2Input input = new UploadPartV2Input().setBucket(this.mBucketName).setKey(this.mKey).setUploadID(this.mUploadId).setPartNumber(partNumber).setContentLength(partSize).setContent((InputStream)wrappedContent);
            UploadPartV2Output output = this.getClient().uploadPart(input);
            this.mTags.add(new UploadedPartV2().setPartNumber(partNumber).setEtag(output.getEtag()));
        }
        catch (IOException e) {
            LOG.debug("failed to upload part.", (Throwable)e);
            throw new IOException(String.format("failed to upload part. key: %s part number: %s uploadId: %s", this.mKey, partNumber, this.mUploadId), e);
        }
    }

    protected void initMultiPartUploadInternal() throws IOException {
        try {
            CreateMultipartUploadInput create = new CreateMultipartUploadInput().setBucket(this.mBucketName).setKey(this.mKey);
            CreateMultipartUploadOutput output = this.getClient().createMultipartUpload(create);
            this.mUploadId = output.getUploadID();
        }
        catch (TosException e) {
            LOG.debug("failed to init multi part upload", (Throwable)e);
            throw AlluxioTosException.from("failed to init multi part upload", e);
        }
    }

    protected void completeMultiPartUploadInternal() {
        try {
            LOG.debug("complete multi part {}", (Object)this.mUploadId);
            CompleteMultipartUploadV2Input complete = new CompleteMultipartUploadV2Input().setBucket(this.mBucketName).setKey(this.mKey).setUploadID(this.mUploadId);
            complete.setUploadedParts(this.mTags);
            CompleteMultipartUploadV2Output completedOutput = this.getClient().completeMultipartUpload(complete);
            this.mContentHash = completedOutput.getEtag();
        }
        catch (TosException e) {
            LOG.debug("failed to complete multi part upload", (Throwable)e);
            throw AlluxioTosException.from(String.format("failed to complete multi part upload, key: %s, upload id: %s", this.mKey, this.mUploadId), e);
        }
    }

    protected void createEmptyObject(String key) {
        try {
            PutObjectInput putObjectInput = new PutObjectInput().setBucket(this.mBucketName).setKey(key).setContent((InputStream)new ByteArrayInputStream(new byte[0])).setContentLength(0L);
            this.mContentHash = this.getClient().putObject(putObjectInput).getEtag();
        }
        catch (TosException e) {
            LOG.debug("failed to create empty object", (Throwable)e);
            throw AlluxioTosException.from(e);
        }
    }

    protected void putObject(String key, File file, @Nullable String md5) throws IOException {
        try (InputStream content = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            PutObjectInput putObjectInput = new PutObjectInput().setBucket(this.mBucketName).setKey(key).setContent(content).setContentLength(file.length());
            this.mContentHash = this.getClient().putObject(putObjectInput).getEtag();
        }
        catch (TosException e) {
            LOG.debug("failed to put object", (Throwable)e);
            throw AlluxioTosException.from(e);
        }
    }

    public Optional<String> getContentHash() {
        return Optional.ofNullable(this.mContentHash);
    }

    protected TOSV2 getClient() {
        return this.mClient;
    }
}

