/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.tos;

import alluxio.underfs.ContentHashable;
import alluxio.underfs.tos.AlluxioTosException;
import alluxio.util.CommonUtils;
import alluxio.util.io.PathUtils;
import com.google.common.base.Preconditions;
import com.volcengine.tos.TOSV2;
import com.volcengine.tos.TosException;
import com.volcengine.tos.internal.util.base64.Base64;
import com.volcengine.tos.model.object.ObjectMetaRequestOptions;
import com.volcengine.tos.model.object.PutObjectInput;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class TOSOutputStream
extends OutputStream
implements ContentHashable {
    private static final Logger LOG = LoggerFactory.getLogger(TOSOutputStream.class);
    private final String mBucketName;
    private final String mKey;
    private final File mFile;
    private final TOSV2 mTOSClient;
    private OutputStream mLocalOutputStream;
    private MessageDigest mHash;
    private AtomicBoolean mClosed = new AtomicBoolean(false);
    private String mContentHash;

    public TOSOutputStream(String bucketName, String key, TOSV2 client, List<String> tmpDirs) throws IOException {
        Preconditions.checkArgument((bucketName != null && !bucketName.isEmpty() ? 1 : 0) != 0, (Object)"Bucket name must not be null or empty.");
        Preconditions.checkArgument((key != null && !key.isEmpty() ? 1 : 0) != 0, (Object)"COS path must not be null or empty.");
        Preconditions.checkArgument((client != null ? 1 : 0) != 0, (Object)"COSClient must not be null.");
        this.mBucketName = bucketName;
        this.mKey = key;
        this.mTOSClient = client;
        this.mFile = new File(PathUtils.concatPath((Object)CommonUtils.getTmpDir(tmpDirs), (Object)UUID.randomUUID()));
        try {
            this.mHash = MessageDigest.getInstance("MD5");
            this.mLocalOutputStream = new BufferedOutputStream(new DigestOutputStream(Files.newOutputStream(this.mFile.toPath(), new OpenOption[0]), this.mHash));
        }
        catch (NoSuchAlgorithmException e) {
            LOG.warn("Algorithm not available for MD5 hash.", (Throwable)e);
            this.mHash = null;
            this.mLocalOutputStream = new BufferedOutputStream(Files.newOutputStream(this.mFile.toPath(), new OpenOption[0]));
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.mLocalOutputStream.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.mLocalOutputStream.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.mLocalOutputStream.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.mLocalOutputStream.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.mClosed.getAndSet(true)) {
            return;
        }
        this.mLocalOutputStream.close();
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(this.mFile.toPath(), new OpenOption[0]));){
            ObjectMetaRequestOptions meta = new ObjectMetaRequestOptions();
            meta.setContentLength(this.mFile.length());
            if (this.mHash != null) {
                byte[] hashBytes = this.mHash.digest();
                meta.setContentMD5(new String(Base64.encodeBase64((byte[])hashBytes)));
            }
            PutObjectInput putObjectInput = new PutObjectInput().setBucket(this.mBucketName).setKey(this.mKey).setOptions(meta).setContent((InputStream)in);
            this.mContentHash = this.mTOSClient.putObject(putObjectInput).getEtag();
        }
        catch (TosException e) {
            LOG.error("Failed to upload {}. ", (Object)this.mKey);
            throw AlluxioTosException.from(e);
        }
        finally {
            if (!this.mFile.delete()) {
                LOG.error("Failed to delete temporary file @ {}", (Object)this.mFile.getPath());
            }
        }
    }

    public Optional<String> getContentHash() {
        return Optional.ofNullable(this.mContentHash);
    }
}

