/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.tos;

import alluxio.AlluxioURI;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.retry.RetryPolicy;
import alluxio.underfs.ObjectUnderFileSystem;
import alluxio.underfs.UnderFileSystemConfiguration;
import alluxio.underfs.options.OpenOptions;
import alluxio.underfs.tos.AlluxioTosException;
import alluxio.underfs.tos.TOSInputStream;
import alluxio.underfs.tos.TOSLowLevelOutputStream;
import alluxio.underfs.tos.TOSOutputStream;
import alluxio.util.UnderFileSystemUtils;
import alluxio.util.executor.ExecutorServiceFactories;
import alluxio.util.io.PathUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.volcengine.tos.TOSClientConfiguration;
import com.volcengine.tos.TOSV2;
import com.volcengine.tos.TOSV2ClientBuilder;
import com.volcengine.tos.TosClientException;
import com.volcengine.tos.TosException;
import com.volcengine.tos.TosServerException;
import com.volcengine.tos.auth.Credentials;
import com.volcengine.tos.auth.StaticCredentials;
import com.volcengine.tos.model.object.AbortMultipartUploadInput;
import com.volcengine.tos.model.object.CopyObjectV2Input;
import com.volcengine.tos.model.object.CopyObjectV2Output;
import com.volcengine.tos.model.object.DeleteMultiObjectsV2Input;
import com.volcengine.tos.model.object.DeleteMultiObjectsV2Output;
import com.volcengine.tos.model.object.DeleteObjectInput;
import com.volcengine.tos.model.object.DeleteObjectOutput;
import com.volcengine.tos.model.object.Deleted;
import com.volcengine.tos.model.object.HeadObjectV2Input;
import com.volcengine.tos.model.object.HeadObjectV2Output;
import com.volcengine.tos.model.object.ListMultipartUploadsV2Input;
import com.volcengine.tos.model.object.ListMultipartUploadsV2Output;
import com.volcengine.tos.model.object.ListObjectsType2Input;
import com.volcengine.tos.model.object.ListObjectsType2Output;
import com.volcengine.tos.model.object.ListedCommonPrefix;
import com.volcengine.tos.model.object.ListedObjectV2;
import com.volcengine.tos.model.object.ListedUpload;
import com.volcengine.tos.model.object.ObjectMetaRequestOptions;
import com.volcengine.tos.model.object.ObjectTobeDeleted;
import com.volcengine.tos.model.object.PutObjectInput;
import com.volcengine.tos.transport.TransportConfig;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class TOSUnderFileSystem
extends ObjectUnderFileSystem {
    private static final Logger LOG = LoggerFactory.getLogger(TOSUnderFileSystem.class);
    private static final String FOLDER_SUFFIX = "/";
    private final TOSV2 mClient;
    private final String mBucketName;
    private final Supplier<ListeningExecutorService> mStreamingUploadExecutor;

    public static TOSUnderFileSystem createInstance(AlluxioURI uri, UnderFileSystemConfiguration conf) {
        String bucketName = UnderFileSystemUtils.getBucketName((AlluxioURI)uri);
        Preconditions.checkArgument((boolean)conf.isSet(PropertyKey.TOS_ACCESS_KEY), (String)"Property %s is required to connect to TOS", (Object)PropertyKey.TOS_ACCESS_KEY);
        Preconditions.checkArgument((boolean)conf.isSet(PropertyKey.TOS_SECRET_KEY), (String)"Property %s is required to connect to TOS", (Object)PropertyKey.TOS_SECRET_KEY);
        Preconditions.checkArgument((boolean)conf.isSet(PropertyKey.TOS_REGION), (String)"Property %s is required to connect to TOS", (Object)PropertyKey.TOS_REGION);
        Preconditions.checkArgument((boolean)conf.isSet(PropertyKey.TOS_ENDPOINT_KEY), (String)"Property %s is required to connect to TOS", (Object)PropertyKey.TOS_ENDPOINT_KEY);
        String accessKey = conf.getString(PropertyKey.TOS_ACCESS_KEY);
        String secretKey = conf.getString(PropertyKey.TOS_SECRET_KEY);
        String regionName = conf.getString(PropertyKey.TOS_REGION);
        String endPoint = conf.getString(PropertyKey.TOS_ENDPOINT_KEY);
        TOSClientConfiguration configuration = TOSClientConfiguration.builder().transportConfig(TOSUnderFileSystem.initializeTOSClientConfig((AlluxioConfiguration)conf)).region(regionName).endpoint(endPoint).credentials((Credentials)new StaticCredentials(accessKey, secretKey)).build();
        TOSV2 tos = new TOSV2ClientBuilder().build(configuration);
        return new TOSUnderFileSystem(uri, tos, bucketName, conf);
    }

    protected TOSUnderFileSystem(AlluxioURI uri, @Nullable TOSV2 tosClient, String bucketName, UnderFileSystemConfiguration conf) {
        super(uri, conf);
        this.mClient = tosClient;
        this.mBucketName = bucketName;
        this.mStreamingUploadExecutor = Suppliers.memoize(() -> {
            int numTransferThreads = conf.getInt(PropertyKey.UNDERFS_TOS_STREAMING_UPLOAD_THREADS);
            ExecutorService service = ExecutorServiceFactories.fixedThreadPool((String)"alluxio-tos-streaming-upload-worker", (int)numTransferThreads).create();
            return MoreExecutors.listeningDecorator((ExecutorService)service);
        });
    }

    public String getUnderFSType() {
        return "tos";
    }

    public void setOwner(String path, String user, String group) {
    }

    public void setMode(String path, short mode) throws IOException {
    }

    public void cleanup() {
        long cleanAge = this.mUfsConf.getMs(PropertyKey.UNDERFS_TOS_INTERMEDIATE_UPLOAD_CLEAN_AGE);
        Date cleanBefore = new Date(new Date().getTime() - cleanAge);
        boolean isTruncated = true;
        String keyMarker = null;
        String uploadIdMarker = null;
        int maxKeys = 10;
        try {
            while (isTruncated) {
                ListMultipartUploadsV2Input input = new ListMultipartUploadsV2Input().setBucket(this.mBucketName).setMaxUploads(maxKeys).setKeyMarker(keyMarker).setUploadIDMarker(uploadIdMarker);
                ListMultipartUploadsV2Output output = this.mClient.listMultipartUploads(input);
                if (output.getUploads() != null) {
                    for (int i = 0; i < output.getUploads().size(); ++i) {
                        ListedUpload upload = (ListedUpload)output.getUploads().get(i);
                        if (!upload.getInitiated().before(cleanBefore)) continue;
                        this.mClient.abortMultipartUpload(new AbortMultipartUploadInput().setBucket(this.mBucketName).setKey(upload.getKey()).setUploadID(upload.getUploadID()));
                    }
                }
                isTruncated = output.isTruncated();
                keyMarker = output.getNextKeyMarker();
                uploadIdMarker = output.getNextUploadIdMarker();
            }
        }
        catch (TosException e) {
            LOG.error("Failed to cleanup TOS uploads", (Throwable)e);
            throw AlluxioTosException.from(e);
        }
    }

    protected boolean copyObject(String src, String dst) {
        LOG.debug("Copying {} to {}", (Object)src, (Object)dst);
        try {
            CopyObjectV2Input input = new CopyObjectV2Input().setBucket(this.mBucketName).setKey(dst).setSrcBucket(this.mBucketName).setSrcKey(src);
            CopyObjectV2Output output = this.mClient.copyObject(input);
            return true;
        }
        catch (TosException e) {
            LOG.error("Failed to rename file {} to {}", new Object[]{src, dst, e});
            return false;
        }
    }

    public boolean createEmptyObject(String key) {
        try {
            ObjectMetaRequestOptions metaRequestOptions = new ObjectMetaRequestOptions();
            metaRequestOptions.setContentLength(0L);
            ByteArrayInputStream stream = new ByteArrayInputStream(new byte[0]);
            PutObjectInput input = new PutObjectInput().setBucket(this.mBucketName).setKey(key).setOptions(metaRequestOptions).setContent((InputStream)stream);
            this.mClient.putObject(input);
            return true;
        }
        catch (TosException e) {
            LOG.error("Failed to create object: {}", (Object)key, (Object)e);
            return false;
        }
    }

    protected OutputStream createObject(String key) throws IOException {
        if (this.mUfsConf.getBoolean(PropertyKey.UNDERFS_TOS_STREAMING_UPLOAD_ENABLED)) {
            return new TOSLowLevelOutputStream(this.mBucketName, key, this.mClient, this.mStreamingUploadExecutor.get(), (AlluxioConfiguration)this.mUfsConf);
        }
        return new TOSOutputStream(this.mBucketName, key, this.mClient, this.mUfsConf.getList(PropertyKey.TMP_DIRS));
    }

    protected boolean deleteObject(String key) {
        try {
            DeleteObjectInput input = new DeleteObjectInput().setBucket(this.mBucketName).setKey(key);
            DeleteObjectOutput deleteObjectOutput = this.mClient.deleteObject(input);
        }
        catch (TosException e) {
            LOG.error("Failed to delete {}", (Object)key, (Object)e);
            return false;
        }
        return true;
    }

    protected List<String> deleteObjects(List<String> keys) {
        try {
            ArrayList<ObjectTobeDeleted> list = new ArrayList<ObjectTobeDeleted>();
            for (String key : keys) {
                list.add(new ObjectTobeDeleted().setKey(key));
            }
            DeleteMultiObjectsV2Input input = new DeleteMultiObjectsV2Input().setBucket(this.mBucketName).setObjects(list);
            DeleteMultiObjectsV2Output output = this.mClient.deleteMultiObjects(input);
            return output.getDeleteds().stream().map(Deleted::getKey).collect(Collectors.toList());
        }
        catch (TosException e) {
            LOG.error("Failed to delete objects", (Throwable)e);
            throw AlluxioTosException.from(e);
        }
    }

    protected String getFolderSuffix() {
        return FOLDER_SUFFIX;
    }

    protected ObjectUnderFileSystem.ObjectListingChunk getObjectListingChunk(String key, boolean recursive) throws IOException {
        String delimiter = recursive ? "" : PATH_SEPARATOR;
        key = PathUtils.normalizePath((String)key, (String)PATH_SEPARATOR);
        key = key.equals(PATH_SEPARATOR) ? "" : key;
        ListObjectsType2Input input = new ListObjectsType2Input().setBucket(this.mBucketName).setDelimiter(delimiter).setPrefix(key);
        ListObjectsType2Output output = this.getObjectListingChunk(input);
        if (output != null) {
            return new TOSObjectListingChunk(input, output);
        }
        return null;
    }

    private ListObjectsType2Output getObjectListingChunk(ListObjectsType2Input input) {
        ListObjectsType2Output result;
        try {
            result = this.mClient.listObjectsType2(input);
        }
        catch (TosException e) {
            LOG.error("Failed to list path {}", (Object)input.getPrefix(), (Object)e);
            result = null;
        }
        return result;
    }

    protected ObjectUnderFileSystem.ObjectStatus getObjectStatus(String key) {
        try {
            HeadObjectV2Input input = new HeadObjectV2Input().setBucket(this.mBucketName).setKey(key);
            HeadObjectV2Output output = this.mClient.headObject(input);
            if (output == null) {
                return null;
            }
            Date lastModifiedDate = output.getLastModifiedInDate();
            Long lastModifiedTime = lastModifiedDate == null ? null : Long.valueOf(lastModifiedDate.getTime());
            return new ObjectUnderFileSystem.ObjectStatus(key, output.getEtag(), output.getContentLength(), lastModifiedTime);
        }
        catch (TosServerException e) {
            if (e.getStatusCode() == 404) {
                return null;
            }
            throw AlluxioTosException.from((TosException)((Object)e));
        }
        catch (TosClientException e) {
            LOG.error("Failed to get object status for {}", (Object)key, (Object)e);
            throw AlluxioTosException.from((TosException)((Object)e));
        }
    }

    protected ObjectUnderFileSystem.ObjectPermissions getPermissions() {
        return new ObjectUnderFileSystem.ObjectPermissions("", "", 511);
    }

    protected String getRootKey() {
        return "tos://" + this.mBucketName;
    }

    public static TransportConfig initializeTOSClientConfig(AlluxioConfiguration alluxioConf) {
        int readTimeoutMills = alluxioConf.getInt(PropertyKey.UNDERFS_TOS_READ_TIMEOUT);
        int writeTimeoutMills = alluxioConf.getInt(PropertyKey.UNDERFS_TOS_WRITE_TIMEOUT);
        int connectionTimeoutMills = alluxioConf.getInt(PropertyKey.UNDERFS_TOS_CONNECT_TIMEOUT);
        int maxConnections = alluxioConf.getInt(PropertyKey.UNDERFS_TOS_CONNECT_MAX);
        int idleConnectionTime = alluxioConf.getInt(PropertyKey.UNDERFS_TOS_CONNECT_TTL);
        int maxErrorRetry = alluxioConf.getInt(PropertyKey.UNDERFS_TOS_RETRY_MAX);
        TransportConfig config = TransportConfig.builder().connectTimeoutMills(connectionTimeoutMills).maxConnections(maxConnections).maxRetryCount(maxErrorRetry).readTimeoutMills(readTimeoutMills).writeTimeoutMills(writeTimeoutMills).idleConnectionTimeMills(idleConnectionTime).build();
        return config;
    }

    protected InputStream openObject(String key, OpenOptions options, RetryPolicy retryPolicy) throws IOException {
        try {
            return new TOSInputStream(this.mBucketName, key, this.mClient, options.getOffset(), retryPolicy, this.mUfsConf.getBytes(PropertyKey.UNDERFS_OBJECT_STORE_MULTI_RANGE_CHUNK_SIZE));
        }
        catch (TosException e) {
            LOG.error("Failed to open object: {}", (Object)key, (Object)e);
            throw AlluxioTosException.from(e);
        }
    }

    public void close() throws IOException {
        super.close();
        this.mClient.close();
    }

    private final class TOSObjectListingChunk
    implements ObjectUnderFileSystem.ObjectListingChunk {
        final ListObjectsType2Input mInput;
        final ListObjectsType2Output mOutput;

        TOSObjectListingChunk(ListObjectsType2Input Input, ListObjectsType2Output Output) throws IOException {
            this.mInput = Input;
            this.mOutput = Output;
            if (this.mOutput == null) {
                throw new IOException("TOS listing result is null");
            }
        }

        public ObjectUnderFileSystem.ObjectStatus[] getObjectStatuses() {
            List objects = this.mOutput.getContents();
            if (objects == null) {
                return new ObjectUnderFileSystem.ObjectStatus[0];
            }
            ObjectUnderFileSystem.ObjectStatus[] ret = new ObjectUnderFileSystem.ObjectStatus[objects.size()];
            int i = 0;
            for (ListedObjectV2 obj : objects) {
                Date lastModifiedDate = obj.getLastModified();
                Long lastModifiedTime = lastModifiedDate == null ? null : Long.valueOf(lastModifiedDate.getTime());
                ret[i++] = new ObjectUnderFileSystem.ObjectStatus(obj.getKey(), obj.getEtag(), obj.getSize(), lastModifiedTime);
            }
            return ret;
        }

        public String[] getCommonPrefixes() {
            List res = this.mOutput.getCommonPrefixes();
            if (res == null) {
                return new String[0];
            }
            return (String[])res.stream().map(ListedCommonPrefix::getPrefix).toArray(String[]::new);
        }

        public ObjectUnderFileSystem.ObjectListingChunk getNextChunk() throws IOException {
            if (this.mOutput.isTruncated()) {
                this.mInput.setContinuationToken(this.mOutput.getNextContinuationToken());
                ListObjectsType2Output nextResult = TOSUnderFileSystem.this.mClient.listObjectsType2(this.mInput);
                if (nextResult != null) {
                    return new TOSObjectListingChunk(this.mInput, nextResult);
                }
            }
            return null;
        }

        public Boolean hasNextChunk() {
            return this.mOutput.isTruncated();
        }
    }
}

