/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.tos;

import alluxio.AlluxioURI;
import alluxio.conf.PropertyKey;
import alluxio.underfs.UnderFileSystem;
import alluxio.underfs.UnderFileSystemConfiguration;
import alluxio.underfs.UnderFileSystemFactory;
import alluxio.underfs.tos.AlluxioTosException;
import alluxio.underfs.tos.TOSUnderFileSystem;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.volcengine.tos.TosException;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TOSUnderFileSystemFactory
implements UnderFileSystemFactory {
    private static final Logger LOG = LoggerFactory.getLogger(TOSUnderFileSystemFactory.class);

    public UnderFileSystem create(String path, UnderFileSystemConfiguration conf) {
        Preconditions.checkNotNull((Object)path, (Object)"path");
        if (this.checkTOSCredentials(conf)) {
            try {
                return TOSUnderFileSystem.createInstance(new AlluxioURI(path), conf);
            }
            catch (TosException e) {
                LOG.warn("Failed to create TOS Under File System: {}", (Object)e.getMessage());
                throw AlluxioTosException.from(e);
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        String err = "TOS Credentials not available, cannot create TOS Under File System.";
        throw Throwables.propagate((Throwable)new IOException(err));
    }

    public boolean supportsPath(String path) {
        return path != null && path.startsWith("tos://");
    }

    private boolean checkTOSCredentials(UnderFileSystemConfiguration conf) {
        return conf.isSet(PropertyKey.TOS_ACCESS_KEY) && conf.isSet(PropertyKey.TOS_SECRET_KEY) && conf.isSet(PropertyKey.TOS_ENDPOINT_KEY) && conf.isSet(PropertyKey.TOS_REGION);
    }
}

