/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.wasb;

import alluxio.AlluxioURI;
import alluxio.conf.AlluxioConfiguration;
import alluxio.underfs.UnderFileSystem;
import alluxio.underfs.UnderFileSystemConfiguration;
import alluxio.underfs.UnderFileSystemFactory;
import alluxio.underfs.wasb.WasbUnderFileSystem;
import com.google.common.base.Preconditions;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class WasbUnderFileSystemFactory
implements UnderFileSystemFactory {
    public UnderFileSystem create(String path, UnderFileSystemConfiguration conf, AlluxioConfiguration alluxioConf) {
        Preconditions.checkArgument((path != null ? 1 : 0) != 0, (Object)"path may not be null");
        return WasbUnderFileSystem.createInstance(new AlluxioURI(path), conf, alluxioConf);
    }

    public boolean supportsPath(String path) {
        return path != null && path.startsWith("wasb://");
    }
}

