/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.wasb;

import alluxio.AlluxioURI;
import alluxio.conf.PropertyKey;
import alluxio.underfs.UnderFileSystemConfiguration;
import alluxio.underfs.hdfs.HdfsUnderFileSystem;
import alluxio.underfs.options.FileLocationOptions;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class WasbUnderFileSystem
extends HdfsUnderFileSystem {
    private static final Logger LOG = LoggerFactory.getLogger(WasbUnderFileSystem.class);
    public static final String SCHEME_INSECURE = "wasb://";
    public static final String SCHEME_SECURE = "wasbs://";

    public static Configuration createConfiguration(UnderFileSystemConfiguration conf, Boolean isSecure) {
        Configuration wasbConf = HdfsUnderFileSystem.createConfiguration((UnderFileSystemConfiguration)conf);
        for (Map.Entry entry : conf.toMap().entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!PropertyKey.Template.UNDERFS_AZURE_ACCOUNT_KEY.matches(key)) continue;
            wasbConf.set(key, value);
        }
        if (isSecure.booleanValue()) {
            wasbConf.set("fs.AbstractFileSystem.wasbs.impl", "org.apache.hadoop.fs.azure.Wasbs");
            wasbConf.set("fs.wasbs.impl", "org.apache.hadoop.fs.azure.NativeAzureFileSystem");
        } else {
            wasbConf.set("fs.AbstractFileSystem.wasb.impl", "org.apache.hadoop.fs.azure.Wasb");
            wasbConf.set("fs.wasb.impl", "org.apache.hadoop.fs.azure.NativeAzureFileSystem");
        }
        return wasbConf;
    }

    public static WasbUnderFileSystem createInstance(AlluxioURI uri, UnderFileSystemConfiguration conf) {
        Configuration wasbConf = WasbUnderFileSystem.createConfiguration(conf, uri.getScheme().startsWith(SCHEME_SECURE));
        return new WasbUnderFileSystem(uri, conf, wasbConf);
    }

    public WasbUnderFileSystem(AlluxioURI ufsUri, UnderFileSystemConfiguration conf, Configuration wasbConf) {
        super(ufsUri, conf, wasbConf);
    }

    public String getUnderFSType() {
        return "wasb";
    }

    public long getBlockSizeByte(String path) throws IOException {
        return this.mUfsConf.getBytes(PropertyKey.USER_BLOCK_SIZE_BYTES_DEFAULT);
    }

    public List<String> getFileLocations(String path) throws IOException {
        LOG.debug("getFileLocations is not supported when using WasbUnderFileSystem.");
        return null;
    }

    public List<String> getFileLocations(String path, FileLocationOptions options) throws IOException {
        LOG.debug("getFileLocations is not supported when using WasbUnderFileSystem.");
        return null;
    }
}

