/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.web;

import alluxio.AlluxioURI;
import alluxio.conf.PropertyKey;
import alluxio.underfs.ConsistentUnderFileSystem;
import alluxio.underfs.UfsDirectoryStatus;
import alluxio.underfs.UfsFileStatus;
import alluxio.underfs.UfsStatus;
import alluxio.underfs.UnderFileSystem;
import alluxio.underfs.UnderFileSystemConfiguration;
import alluxio.underfs.options.CreateOptions;
import alluxio.underfs.options.DeleteOptions;
import alluxio.underfs.options.FileLocationOptions;
import alluxio.underfs.options.MkdirsOptions;
import alluxio.underfs.options.OpenOptions;
import alluxio.underfs.web.WebUnderFileSystemFactory;
import alluxio.util.UnderFileSystemUtils;
import alluxio.util.network.HttpUtils;
import com.google.common.io.ByteStreams;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.http.Header;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class WebUnderFileSystem
extends ConsistentUnderFileSystem {
    private static final Logger LOG = LoggerFactory.getLogger(WebUnderFileSystem.class);
    private int mTimeout = (int)this.mUfsConf.getMs(PropertyKey.UNDERFS_WEB_CONNECTION_TIMEOUT);
    private final String mUnsupportedMsg = "Unsupported operation for WebUnderFileSystem.";

    public WebUnderFileSystem(AlluxioURI uri, UnderFileSystemConfiguration ufsConf) {
        super(uri, ufsConf);
    }

    public String getUnderFSType() {
        return "web";
    }

    public void cleanup() throws IOException {
        throw new IOException("Unsupported operation for WebUnderFileSystem.");
    }

    public void close() throws IOException {
        throw new IOException("Unsupported operation for WebUnderFileSystem.");
    }

    public OutputStream create(String path, CreateOptions options) throws IOException {
        throw new IOException("Unsupported operation for WebUnderFileSystem.");
    }

    public boolean deleteDirectory(String path, DeleteOptions options) throws IOException {
        throw new IOException("Unsupported operation for WebUnderFileSystem.");
    }

    public boolean deleteFile(String path) throws IOException {
        throw new IOException("Unsupported operation for WebUnderFileSystem.");
    }

    public boolean exists(String path) throws IOException {
        return HttpUtils.head((String)path, (Integer)this.mTimeout) != null;
    }

    public long getBlockSizeByte(String path) throws IOException {
        if (!this.exists(path)) {
            throw new FileNotFoundException(path);
        }
        return this.mUfsConf.getBytes(PropertyKey.USER_BLOCK_SIZE_BYTES_DEFAULT);
    }

    public UfsDirectoryStatus getDirectoryStatus(String path) throws IOException {
        UfsStatus ufsStatus = this.getStatus(path);
        if (ufsStatus instanceof UfsDirectoryStatus) {
            return (UfsDirectoryStatus)ufsStatus;
        }
        throw new IOException("Failed to getDirectoryStatus: " + path);
    }

    public List<String> getFileLocations(String path) throws IOException {
        return new ArrayList<String>();
    }

    public List<String> getFileLocations(String path, FileLocationOptions options) throws IOException {
        return this.getFileLocations(path);
    }

    public UfsFileStatus getFileStatus(String path) throws IOException {
        UfsStatus ufsStatus = this.getStatus(path);
        if (ufsStatus instanceof UfsFileStatus) {
            return (UfsFileStatus)ufsStatus;
        }
        throw new IOException("Failed to getFileStatus: " + path);
    }

    public long getSpace(String path, UnderFileSystem.SpaceType type) {
        return -1L;
    }

    private UfsStatus getStatus(String path, String fileName) throws IOException {
        long contentLength = 0L;
        long lastModified = new Date().getTime();
        Header[] headers = HttpUtils.head((String)path, (Integer)this.mTimeout);
        if (headers == null) {
            throw new IOException("Failed to getStatus: " + path);
        }
        for (Header header : headers) {
            String headerName = header.getName();
            if (headerName.equalsIgnoreCase("Content-Length")) {
                contentLength = Long.parseLong(header.getValue());
                continue;
            }
            if (!headerName.equalsIgnoreCase("Last-Modified")) continue;
            lastModified = this.parseTimestamp(header.getValue(), this.mUfsConf.get(PropertyKey.UNDERFS_WEB_HEADER_LAST_MODIFIED));
        }
        if (this.isFile(path)) {
            String contentHash = UnderFileSystemUtils.approximateContentHash((long)contentLength, (long)lastModified);
            return new UfsFileStatus(fileName == null ? path : fileName, contentHash, contentLength, lastModified, "", "", 288, this.mUfsConf.getBytes(PropertyKey.USER_BLOCK_SIZE_BYTES_DEFAULT));
        }
        return new UfsDirectoryStatus(fileName == null ? path : fileName, "", "", 800, Long.valueOf(lastModified));
    }

    public UfsStatus getStatus(String path) throws IOException {
        return this.getStatus(path, null);
    }

    public boolean isDirectory(String path) throws IOException {
        Elements titleElements;
        String contentType = "";
        Header[] headers = HttpUtils.head((String)path, (Integer)this.mTimeout);
        if (headers == null) {
            return false;
        }
        for (Header header : headers) {
            if (!header.getName().equalsIgnoreCase("Content-Type")) continue;
            contentType = header.getValue();
            break;
        }
        if (contentType.contains("text/html") && (titleElements = Jsoup.connect((String)path).get().select("title")).size() > 0) {
            String title = ((Element)titleElements.get(0)).text();
            List titles = this.mUfsConf.getList(PropertyKey.UNDERFS_WEB_TITLES, ",");
            for (String t : titles) {
                if (!title.contains(t)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isFile(String path) throws IOException {
        return !this.isDirectory(path);
    }

    private long parseTimestamp(String datetime, String format) {
        long timestamp = new Date().getTime();
        if (datetime.length() > 0 && datetime.compareTo("-") != 0) {
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat(format);
                Date parsedDate = dateFormat.parse(datetime);
                timestamp = parsedDate.getTime();
            }
            catch (Exception e) {
                LOG.error("Failed to format {} to a timestamp, {}", (Object)datetime, (Object)e.getMessage());
            }
        }
        return timestamp;
    }

    public UfsStatus[] listStatus(String path) throws IOException {
        int i;
        Element bodyChildNode;
        Document doc;
        try {
            doc = Jsoup.connect((String)path).get();
        }
        catch (Exception e) {
            LOG.error("Failed to get content from URL {}, {}", (Object)path, (Object)e.getMessage());
            return null;
        }
        Elements bodyElements = doc.select("body");
        if (bodyElements.size() == 0) {
            return null;
        }
        Element bodyElement = bodyElements.first();
        Elements bodyChildNodes = bodyElement.children();
        Elements listElements = null;
        Iterator iterator = bodyChildNodes.iterator();
        while (iterator.hasNext() && (listElements = (bodyChildNode = (Element)iterator.next()).select("a")).size() <= 0) {
        }
        if (listElements == null || listElements.size() == 0) {
            return null;
        }
        List parentNames = this.mUfsConf.getList(PropertyKey.UNDERFS_WEB_PARENT_NAMES, ",");
        int flagIndex = -1;
        block5: for (int i2 = 0; flagIndex == -1 && i2 < listElements.size(); ++i2) {
            for (String flag : parentNames) {
                if (!((Element)listElements.get(i2)).text().equalsIgnoreCase(flag)) continue;
                flagIndex = i2;
                continue block5;
            }
        }
        ArrayList<UfsStatus> statusList = new ArrayList<UfsStatus>();
        int n = i = flagIndex == -1 ? 0 : flagIndex;
        while (i < listElements.size()) {
            Element listElement = (Element)listElements.get(i);
            String href = listElement.attr("href");
            String fileName = listElement.text();
            if (!new WebUnderFileSystemFactory().supportsPath(href)) {
                href = path + "/" + href;
            }
            try {
                UfsStatus ufsStatus = this.getStatus(href, fileName);
                statusList.add(ufsStatus);
            }
            catch (IOException e) {
                LOG.error("Failed to get status for url: {}", (Object)href, (Object)e);
            }
            ++i;
        }
        UfsStatus[] rtn = new UfsStatus[statusList.size()];
        return statusList.toArray(rtn);
    }

    public boolean mkdirs(String path, MkdirsOptions options) throws IOException {
        throw new IOException("Unsupported operation for WebUnderFileSystem.");
    }

    public InputStream open(String path, OpenOptions options) throws IOException {
        InputStream inputStream = HttpUtils.getInputStream((String)path, (Integer)this.mTimeout);
        try {
            ByteStreams.skipFully((InputStream)inputStream, (long)options.getOffset());
        }
        catch (IOException e) {
            inputStream.close();
            throw e;
        }
        return inputStream;
    }

    public boolean renameDirectory(String src, String dst) throws IOException {
        throw new IOException("Unsupported operation for WebUnderFileSystem.");
    }

    public boolean renameFile(String src, String dst) throws IOException {
        throw new IOException("Unsupported operation for WebUnderFileSystem.");
    }

    public void setOwner(String path, String user, String group) throws IOException {
        throw new IOException("Unsupported operation for WebUnderFileSystem.");
    }

    public void setMode(String path, short mode) throws IOException {
        throw new IOException("Unsupported operation for WebUnderFileSystem.");
    }

    public void connectFromMaster(String hostname) throws IOException {
        throw new IOException("Unsupported operation for WebUnderFileSystem.");
    }

    public void connectFromWorker(String hostname) throws IOException {
        throw new IOException("Unsupported operation for WebUnderFileSystem.");
    }

    public boolean supportsFlush() throws IOException {
        throw new IOException("Unsupported operation for WebUnderFileSystem.");
    }
}

