/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.web;

import alluxio.AlluxioURI;
import alluxio.underfs.UnderFileSystem;
import alluxio.underfs.UnderFileSystemConfiguration;
import alluxio.underfs.UnderFileSystemFactory;
import alluxio.underfs.web.WebUnderFileSystem;
import com.google.common.base.Preconditions;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class WebUnderFileSystemFactory
implements UnderFileSystemFactory {
    public UnderFileSystem create(String path, UnderFileSystemConfiguration conf) {
        Preconditions.checkNotNull((Object)path, (Object)"path");
        return new WebUnderFileSystem(new AlluxioURI(path), conf);
    }

    public boolean supportsPath(String path) {
        return path != null && (path.startsWith("http://") || path.startsWith("https://"));
    }
}

