/*
 * Decompiled with CFR 0.152.
 */
package org.aludratest.hpalm.entity;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.TimeZone;
import org.aludratest.hpalm.entity.Entity;
import org.aludratest.hpalm.entity.Field;
import org.aludratest.hpalm.entity.Fields;
import org.aludratest.hpalm.infrastructure.HpAlmUtil;

public abstract class AbstractEntityBuilder {
    protected static final DecimalFormat DF_INTEGER = HpAlmUtil.DF_ID;
    protected static final DateFormat DF_DATE = new SimpleDateFormat("yyyy-MM-dd");
    protected static final DateFormat DF_TIME = new SimpleDateFormat("HH:mm:ss");
    private Entity entity;
    private String entityTypeName;

    public AbstractEntityBuilder(String entityTypeName) {
        this.entityTypeName = entityTypeName;
        this.create();
    }

    public static void setTimeZone(TimeZone timeZone) {
        DF_DATE.setTimeZone(timeZone);
        DF_TIME.setTimeZone(timeZone);
    }

    public final Entity create() {
        Entity e = this.entity;
        this.entity = this.entity == null ? new Entity() : new Entity(this.entity);
        this.entity.setType(this.entityTypeName);
        if (this.entity.getFields() == null) {
            this.entity.setFields(new Fields());
        }
        return e;
    }

    protected final void setValue(String fieldName, String value) {
        List<Field> fieldList = this.entity.getFields().getFieldList();
        for (Field f : fieldList) {
            if (!f.getName().equals(fieldName)) continue;
            f.getValue().clear();
            f.getValue().add(value);
            return;
        }
        Field f = new Field();
        f.setName(fieldName);
        f.getValue().add(value);
        this.entity.getFields().getFieldList().add(f);
    }

    static {
        AbstractEntityBuilder.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

