/*
 * Decompiled with CFR 0.152.
 */
package org.aludratest.hpalm.entity;

import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.aludratest.hpalm.entity.Field;
import org.aludratest.hpalm.entity.Fields;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"fields"})
@XmlRootElement(name="Entity")
public class Entity {
    @XmlElement(name="Fields", required=true)
    protected Fields fields;
    @XmlAttribute(name="Type", required=true)
    protected String type;

    public Entity(Entity entity) {
        this.type = entity.getType();
        this.fields = new Fields(entity.getFields());
    }

    public Entity() {
    }

    public Fields getFields() {
        return this.fields;
    }

    public void setFields(Fields value) {
        this.fields = value;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String value) {
        this.type = value;
    }

    public String getStringFieldValue(String fieldName) {
        if (this.fields == null) {
            return null;
        }
        for (Field f : this.fields.getFieldList()) {
            if (!fieldName.equals(f.getName())) continue;
            return f.getValue() == null || f.getValue().isEmpty() ? null : f.getValue().get(0);
        }
        return null;
    }

    public long getLongFieldValue(String fieldName) {
        try {
            return Long.parseLong(this.getStringFieldValue(fieldName));
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public long getId() {
        return this.getLongFieldValue("id");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getType()).append(" (");
        for (Field field : this.getFields().getFieldList()) {
            if (sb.charAt(sb.length() - 1) != '(') {
                sb.append(", ");
            }
            sb.append(field.getName()).append(" = ");
            List<String> values = field.getValue();
            if (values == null || values.isEmpty()) {
                sb.append("null");
                continue;
            }
            if (values.size() == 1) {
                String val = values.get(0);
                if (val == null) {
                    sb.append("null");
                    continue;
                }
                sb.append("\"").append(val).append("\"");
                continue;
            }
            sb.append("[");
            for (String val : values) {
                if (val == null) {
                    sb.append("null");
                    continue;
                }
                sb.append("\"").append(val).append("\"");
            }
            sb.append("]");
        }
        sb.append(")");
        return sb.toString();
    }
}

