/*
 * Decompiled with CFR 0.152.
 */
package org.aludratest.hpalm.impl;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.aludratest.hpalm.HpAlmTestId;
import org.aludratest.hpalm.TestCaseIdResolver;
import org.aludratest.scheduler.node.RunnerLeaf;

public class DefaultTestCaseIdResolver
implements TestCaseIdResolver {
    private static final Pattern PATTERN_ID = Pattern.compile("(^|[^C])ID_([0-9]{1,6})_");
    private static final Pattern PATTERN_CONFIG_ID = Pattern.compile("CID_([0-9]{1,6})_");

    @Override
    public Long getHpAlmTestId(RunnerLeaf testCase) {
        String testClassName;
        if (testCase.getTestInvoker() != null && testCase.getTestInvoker().getTestClass() != null) {
            Class testClass = testCase.getTestInvoker().getTestClass();
            HpAlmTestId testId = testClass.getAnnotation(HpAlmTestId.class);
            if (testId != null) {
                return testId.value();
            }
            testClassName = testClass.getName();
        } else {
            testClassName = testCase.getParent().getName();
        }
        Matcher m = PATTERN_ID.matcher(testClassName);
        if (m.find()) {
            return Long.valueOf(m.group(2));
        }
        return null;
    }

    @Override
    public Long getHpAlmTestConfigId(RunnerLeaf testCase) {
        Matcher m = PATTERN_CONFIG_ID.matcher(testCase.getName());
        if (m.find()) {
            return Long.valueOf(m.group(1));
        }
        return null;
    }
}

