/*
 * Decompiled with CFR 0.152.
 */
package org.aludratest.hpalm.infrastructure;

import java.util.Collections;
import java.util.Iterator;
import org.aludratest.hpalm.entity.Entity;
import org.aludratest.hpalm.entity.EntityResultSet;
import org.aludratest.hpalm.infrastructure.EntityCollection;
import org.aludratest.hpalm.infrastructure.HpAlmSession;

public class PagedEntityCollectionImpl
implements EntityCollection {
    private String queryUrl;
    private HpAlmSession session;
    private int totalCount;
    private EntityResultSet firstResultSet;

    public PagedEntityCollectionImpl(HpAlmSession session, String queryUrl, EntityResultSet firstResultSet) {
        this.session = session;
        this.queryUrl = queryUrl;
        this.firstResultSet = firstResultSet;
        this.totalCount = firstResultSet.getTotalResults();
    }

    @Override
    public Iterator<Entity> iterator() {
        if (this.firstResultSet == null || this.firstResultSet.getEntities() == null) {
            return Collections.emptySet().iterator();
        }
        if (this.totalCount <= this.firstResultSet.getEntities().size()) {
            return Collections.unmodifiableList(this.firstResultSet.getEntities()).iterator();
        }
        return new PagedEntityCollectionIterator();
    }

    @Override
    public int getTotalCount() {
        return this.totalCount;
    }

    private class PagedEntityCollectionIterator
    implements Iterator<Entity> {
        private EntityResultSet currentSet;
        private int offset = 1;
        private int totalCount;
        private int listIndex;

        private PagedEntityCollectionIterator() {
            this.currentSet = PagedEntityCollectionImpl.this.firstResultSet;
            this.totalCount = this.currentSet.getTotalResults();
        }

        private void querySet() {
            String url = PagedEntityCollectionImpl.this.queryUrl;
            url = url + (url.contains("?") ? "&" : "?");
            url = url + "start-index=" + this.offset;
            try {
                this.currentSet = PagedEntityCollectionImpl.this.session.doGet(url);
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not retrieve next bunch of entities", e);
            }
            if (this.currentSet.getEntities() == null || this.currentSet.getEntities().isEmpty()) {
                this.currentSet = null;
                this.totalCount = 0;
            } else {
                this.totalCount = this.currentSet.getTotalResults();
            }
        }

        @Override
        public boolean hasNext() {
            return this.currentSet != null && this.offset + this.listIndex <= this.totalCount;
        }

        @Override
        public Entity next() {
            if (!this.hasNext()) {
                throw new IllegalStateException("No more elements available");
            }
            if (this.listIndex == this.currentSet.getEntities().size()) {
                this.offset += this.listIndex;
                this.querySet();
                this.listIndex = 0;
                if (this.currentSet == null) {
                    throw new IllegalStateException("No more elements returned by HP ALM, although expected");
                }
            }
            Entity e = this.currentSet.getEntities().get(this.listIndex++);
            return e;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

