/*
 * Decompiled with CFR 0.152.
 */
package org.aludratest.hpalm.listener;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.aludratest.config.ConfigurationException;
import org.aludratest.hpalm.TestCaseIdResolver;
import org.aludratest.hpalm.entity.AbstractEntityBuilder;
import org.aludratest.hpalm.entity.Entity;
import org.aludratest.hpalm.entity.RunStepBuilder;
import org.aludratest.hpalm.entity.RunStepStatus;
import org.aludratest.hpalm.entity.TestInstanceBuilder;
import org.aludratest.hpalm.entity.TestRunBuilder;
import org.aludratest.hpalm.impl.HpAlmConfiguration;
import org.aludratest.hpalm.infrastructure.EntityCollection;
import org.aludratest.hpalm.infrastructure.HpAlmException;
import org.aludratest.hpalm.infrastructure.HpAlmSession;
import org.aludratest.hpalm.infrastructure.HpAlmUtil;
import org.aludratest.impl.log4testing.ElementName;
import org.aludratest.impl.log4testing.ElementType;
import org.aludratest.impl.log4testing.TechnicalArgument;
import org.aludratest.impl.log4testing.TechnicalLocator;
import org.aludratest.scheduler.AbstractRunnerListener;
import org.aludratest.scheduler.RunnerListener;
import org.aludratest.scheduler.RunnerTree;
import org.aludratest.scheduler.node.RunnerLeaf;
import org.aludratest.testcase.TestStatus;
import org.aludratest.testcase.event.TestStepInfo;
import org.aludratest.testcase.event.attachment.Attachment;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.databene.formats.html.util.HTMLUtil;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(role=RunnerListener.class, hint="hpalm")
public class HpAlmTestListener
extends AbstractRunnerListener {
    private static final Logger LOG = LoggerFactory.getLogger(HpAlmTestListener.class);
    private static final String[] testStepColumns = new String[]{"Started", "Command", "Element Type", "Element Name", "Data", "Error Message", "Technical Locator", "Technical Arguments", "Comment"};
    private static final Map<TestStatus, String> cellStyle = new EnumMap<TestStatus, String>(TestStatus.class);
    @Requirement
    private TestCaseIdResolver idResolver;
    @Requirement
    private HpAlmConfiguration configuration;
    private HpAlmWorkerThread workerThread;

    private TestCaseIdResolver getIdResolver() {
        return this.idResolver;
    }

    public void startingTestProcess(RunnerTree runnerTree) {
        if (this.configuration.isEnabled()) {
            if (this.getIdResolver() == null) {
                LOG.error("No IdResolver registered for HP ALM connector. Connector is disabled now.");
            } else {
                this.workerThread = new HpAlmWorkerThread(this.configuration);
                this.workerThread.start();
            }
        }
    }

    public void startingTestLeaf(RunnerLeaf runnerLeaf) {
        if (!this.configuration.isEnabled() || this.getIdResolver() == null) {
            return;
        }
        Long id = this.getIdResolver().getHpAlmTestId(runnerLeaf);
        if (id == null) {
            return;
        }
        Long configId = this.getIdResolver().getHpAlmTestConfigId(runnerLeaf);
        TestCaseData data = new TestCaseData();
        TestRunBuilder builder = new TestRunBuilder();
        builder.setTestId(id);
        if (Boolean.TRUE.equals(runnerLeaf.getAttribute("IGNORE"))) {
            builder.setStatus(RunStepStatus.BLOCKED.displayName());
        } else {
            builder.setStatus(RunStepStatus.PASSED.displayName());
        }
        data.startTime = new DateTime();
        data.testRunBuilder = builder;
        data.hpAlmId = id;
        data.hpAlmConfigId = configId;
        runnerLeaf.setAttribute("hpalmData", (Object)data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newTestStepGroup(RunnerLeaf runnerLeaf, String groupName) {
        TestCaseData data = (TestCaseData)runnerLeaf.getAttribute("hpalmData");
        if (data == null) {
            return;
        }
        RunStepBuilder builder = new RunStepBuilder();
        while (!this.workerThread.isTimeZoneInitialized()) {
            HpAlmWorkerThread hpAlmWorkerThread = this.workerThread;
            synchronized (hpAlmWorkerThread) {
                try {
                    this.workerThread.wait();
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }
        builder.setName(groupName).setExecutionDateTime(new Date()).setStatus(data.alreadyFailed ? RunStepStatus.NO_RUN : RunStepStatus.PASSED);
        TestStepData step = new TestStepData();
        step.runStepBuilder = builder;
        step.sbDescription = new StringBuilder();
        step.sbDescription.append("<html><head></head><body><table><tr ").append(cellStyle.get(TestStatus.PASSED)).append(">");
        for (String s : testStepColumns) {
            step.sbDescription.append("<th>").append(s).append("</th>");
        }
        step.sbDescription.append("</tr>");
        data.testSteps.add(step);
    }

    public void newTestStep(RunnerLeaf runnerLeaf, TestStepInfo testStepInfo) {
        TestCaseData data = (TestCaseData)runnerLeaf.getAttribute("hpalmData");
        if (data == null || data.testSteps.isEmpty()) {
            return;
        }
        TestStepData step = (TestStepData)data.testSteps.get(data.testSteps.size() - 1);
        StringBuilder sb = step.sbDescription;
        for (Attachment attachment : testStepInfo.getAttachments()) {
            step.attachments.add(attachment);
        }
        sb.append("<tr ").append(cellStyle.get(testStepInfo.getTestStatus())).append(">");
        String value = "";
        DateTime dt = testStepInfo.getStartingTime();
        if (dt != null && data.startTime != null) {
            value = new Duration((ReadableInstant)data.startTime, (ReadableInstant)dt).getStandardSeconds() + "s";
        }
        sb.append("<td>").append(value).append("</td>");
        sb.append("<td>").append(HpAlmTestListener.nullAsEmpty(testStepInfo.getCommand())).append("</td>");
        sb.append("<td>").append(HpAlmTestListener.nullAsEmpty(this.getSingleStringArgument(testStepInfo, ElementType.class))).append("</td>");
        sb.append("<td>").append(HpAlmTestListener.nullAsEmpty(this.getSingleStringArgument(testStepInfo, ElementName.class))).append("</td>");
        sb.append("<td>").append(this.getArgumentsString(testStepInfo, null)).append("</td>");
        sb.append("<td>").append(HpAlmTestListener.nullAsEmpty(testStepInfo.getErrorMessage())).append("</td>");
        sb.append("<td>").append(HpAlmTestListener.nullAsEmpty(this.getSingleStringArgument(testStepInfo, TechnicalLocator.class))).append("</td>");
        sb.append("<td>").append(this.getArgumentsString(testStepInfo, TechnicalArgument.class)).append("</td>");
        sb.append("<td>");
        if (testStepInfo.getError() != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            testStepInfo.getError().printStackTrace(pw);
            pw.flush();
            sb.append(HTMLUtil.escape((String)sw.toString()).replace("\n", "<br />"));
        }
        sb.append("</td>");
        sb.append("</tr>");
        if (data.alreadyFailed) {
            return;
        }
        RunStepBuilder lastStep = step.runStepBuilder;
        switch (testStepInfo.getTestStatus()) {
            case FAILED: 
            case FAILEDACCESS: 
            case FAILEDAUTOMATION: 
            case FAILEDPERFORMANCE: 
            case INCONCLUSIVE: {
                lastStep.setStatus(RunStepStatus.FAILED);
                if (!RunStepStatus.BLOCKED.displayName().equals(data.testRunBuilder.create().getStringFieldValue("status"))) {
                    data.testRunBuilder.setStatus(RunStepStatus.FAILED.displayName());
                }
                data.alreadyFailed = true;
                break;
            }
        }
    }

    public void finishedTestLeaf(RunnerLeaf runnerLeaf) {
        TestCaseData data = (TestCaseData)runnerLeaf.getAttribute("hpalmData");
        if (data == null || !this.workerThread.isAlive()) {
            return;
        }
        DateTime endTime = new DateTime();
        data.testRunBuilder.setExecutionDateAndTime(data.startTime.toDate()).setDuration((endTime.getMillis() - data.startTime.getMillis()) / 1000L).setName(runnerLeaf.getName().substring(runnerLeaf.getName().lastIndexOf(46) + 1));
        for (TestStepData step : data.testSteps) {
            if (step.sbDescription.toString().endsWith("</html>")) continue;
            step.sbDescription.append("</table></body></html>");
        }
        this.workerThread.addTestRun(data);
    }

    public void finishedTestProcess(RunnerTree runnerTree) {
        if (this.workerThread != null) {
            this.workerThread.terminate();
            try {
                this.workerThread.join();
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    private String getSingleStringArgument(TestStepInfo testStepInfo, Class<? extends Annotation> annotClass) {
        Object[] args = testStepInfo.getArguments(annotClass);
        if (args == null || args.length == 0) {
            return null;
        }
        return this.toString(args[0]);
    }

    private String getArgumentsString(TestStepInfo testStepInfo, Class<? extends Annotation> annotClass) {
        Object[] args = testStepInfo.getArguments(annotClass);
        if (args == null || args.length == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (Object o : args) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(this.toString(o));
        }
        return sb.toString();
    }

    private String toString(Object o) {
        if (o == null) {
            return "null";
        }
        if (o.getClass().isArray()) {
            if (!o.getClass().getComponentType().isPrimitive()) {
                return Arrays.toString((Object[])o);
            }
            if (o.getClass().getComponentType() == Integer.TYPE) {
                return Arrays.toString((int[])o);
            }
            if (o.getClass().getComponentType() == Float.TYPE) {
                return Arrays.toString((float[])o);
            }
            if (o.getClass().getComponentType() == Boolean.TYPE) {
                return Arrays.toString((boolean[])o);
            }
            if (o.getClass().getComponentType() == Double.TYPE) {
                return Arrays.toString((double[])o);
            }
            if (o.getClass().getComponentType() == Short.TYPE) {
                return Arrays.toString((short[])o);
            }
        }
        return o.toString();
    }

    private static String nullAsEmpty(String s) {
        return s == null ? "" : s;
    }

    static {
        cellStyle.put(TestStatus.PASSED, "style=\"background-color: #BBFFCC\"");
        cellStyle.put(TestStatus.FAILED, "style=\"background-color: #FFAAAA\"");
        cellStyle.put(TestStatus.INCONCLUSIVE, "style=\"background-color: #88BBFF\"");
        cellStyle.put(TestStatus.IGNORED, "style=\"background-color: #BBBBBB\"");
        cellStyle.put(TestStatus.FAILEDACCESS, "style=\"background-color: #EE88FF\"");
        cellStyle.put(TestStatus.FAILEDPERFORMANCE, "style=\"background-color: #DDAAFF\"");
        cellStyle.put(TestStatus.FAILEDAUTOMATION, "style=\"background-color: #FFFFAA\"");
    }

    private static class HpAlmWorkerThread
    extends Thread {
        private boolean terminated;
        private volatile boolean timeZoneInitialized;
        private HpAlmConfiguration configuration;
        private List<TestCaseData> buffer = new LinkedList<TestCaseData>();

        public HpAlmWorkerThread(HpAlmConfiguration configuration) {
            this.configuration = configuration;
        }

        private synchronized void terminate() {
            this.terminated = true;
            this.notify();
        }

        private synchronized boolean isTerminated() {
            return this.terminated;
        }

        private synchronized void addTestRun(TestCaseData data) {
            this.buffer.add(data);
            this.notify();
        }

        private synchronized boolean isBufferEmpty() {
            return this.buffer.isEmpty();
        }

        public synchronized boolean isTimeZoneInitialized() {
            return this.timeZoneInitialized;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Entity testSet;
            Entity testSetFolder;
            HpAlmSession session;
            try {
                this.configuration.getHpAlmUrl();
                this.configuration.getDomain();
                this.configuration.getProject();
                this.configuration.getUserName();
                this.configuration.getPassword();
                this.configuration.getTestSetFolderPath();
                this.configuration.getTestSetName();
            }
            catch (ConfigurationException ce) {
                LOG.error("HP ALM Connector configuration is invalid", (Throwable)ce);
                return;
            }
            try {
                session = HpAlmSession.create(this.configuration.getHpAlmUrl(), this.configuration.getDomain(), this.configuration.getProject(), this.configuration.getUserName(), this.configuration.getPassword());
            }
            catch (IOException e) {
                LOG.error("Could not connect to HP ALM", (Throwable)e);
                return;
            }
            catch (HpAlmException e) {
                LOG.error("Could not connect to HP ALM", (Throwable)e);
                return;
            }
            try {
                AbstractEntityBuilder.setTimeZone(session.determineServerTimeZone());
                HpAlmWorkerThread e = this;
                synchronized (e) {
                    this.timeZoneInitialized = true;
                    this.notifyAll();
                }
            }
            catch (HpAlmException e) {
                LOG.warn("Could not determine server time zone", (Throwable)e);
            }
            catch (IOException e) {
                LOG.warn("Could not determine server time zone", (Throwable)e);
            }
            try {
                testSetFolder = HpAlmUtil.createTestSetFolderPath(session, this.configuration.getTestSetFolderPath());
            }
            catch (IOException e) {
                LOG.error("Could not create or retrieve configured test set folder " + this.configuration.getTestSetFolderPath(), (Throwable)e);
                return;
            }
            catch (HpAlmException e) {
                LOG.error("Could not create or retrieve configured test set folder " + this.configuration.getTestSetFolderPath(), (Throwable)e);
                return;
            }
            try {
                testSet = HpAlmUtil.createOrGetTestSet(session, testSetFolder.getId(), this.configuration.getTestSetName());
            }
            catch (IOException e) {
                LOG.error("Could not create or retrieve configured test set " + this.configuration.getTestSetName(), (Throwable)e);
                return;
            }
            catch (HpAlmException e) {
                LOG.error("Could not create or retrieve configured test set " + this.configuration.getTestSetName(), (Throwable)e);
                return;
            }
            long testSetId = testSet.getId();
            while (!this.isTerminated()) {
                while (!this.isTerminated() && this.isBufferEmpty()) {
                    try {
                        HpAlmWorkerThread hpAlmWorkerThread = this;
                        synchronized (hpAlmWorkerThread) {
                            this.wait(60000L);
                        }
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                    try {
                        session.extendTimeout();
                    }
                    catch (Exception e) {
                        LOG.warn("Lost connection to HP ALM; trying to reconnect", (Throwable)e);
                        try {
                            session.logout();
                        }
                        catch (Exception ee) {
                            // empty catch block
                        }
                        try {
                            session = HpAlmSession.create(this.configuration.getHpAlmUrl(), this.configuration.getDomain(), this.configuration.getProject(), this.configuration.getUserName(), this.configuration.getPassword());
                        }
                        catch (IOException ee) {
                            LOG.error("Could not connect to HP ALM", (Throwable)ee);
                            return;
                        }
                        catch (HpAlmException ee) {
                            LOG.error("Could not connect to HP ALM", (Throwable)ee);
                            return;
                        }
                    }
                }
                while (!this.isBufferEmpty()) {
                    TestCaseData data;
                    HpAlmWorkerThread ee = this;
                    synchronized (ee) {
                        data = this.buffer.remove(0);
                    }
                    try {
                        this.writeTestRun(session, data, testSetId, data.hpAlmId, data.hpAlmConfigId);
                    }
                    catch (IOException e) {
                        LOG.error("Could not write test case " + (data != null ? data.hpAlmId + "/" + data.hpAlmConfigId : "(unknown)") + " to HP ALM", (Throwable)e);
                    }
                    catch (HpAlmException e) {
                        LOG.error("Could not write test case " + (data != null ? data.hpAlmId + "/" + data.hpAlmConfigId : "(unknown)") + " to HP ALM", (Throwable)e);
                    }
                }
            }
            try {
                session.logout();
            }
            catch (Exception e) {
                LOG.warn("Exception when logging out from HP ALM", (Throwable)e);
            }
        }

        private void writeTestRun(HpAlmSession session, TestCaseData data, long testSetId, long testId, Long testConfigId) throws IOException, HpAlmException {
            Entity testInstance = HpAlmUtil.createOrGetTestInstance(session, testSetId, testId, testConfigId);
            if (testInstance == null) {
                LOG.error("Test instance for testId / testConfigId " + testId + "/" + testConfigId + " could not be created.");
                return;
            }
            Entity testRun = data.testRunBuilder.setTestSetId(testSetId).setTestInstanceId(testInstance.getId()).setOwner(this.configuration.getUserName()).create();
            testRun = session.createEntity(testRun);
            ArrayList<Entity> toDelete = new ArrayList<Entity>();
            EntityCollection ec = session.queryEntities("run-step", "parent-id[" + testRun.getId() + "]");
            for (Entity e : ec) {
                if (e.getId() <= 0L) continue;
                toDelete.add(e);
            }
            for (Entity e : toDelete) {
                session.deleteEntity(e);
            }
            HashSet<String> addedStepNames = new HashSet<String>();
            long testRunId = testRun.getId();
            for (TestStepData step : data.testSteps) {
                RunStepBuilder stepBuilder = step.runStepBuilder.setTestRunId(testRunId);
                if (this.configuration.isWriteDescriptionAndAttachments()) {
                    stepBuilder.setDescription(step.sbDescription.toString());
                }
                Entity stepEntity = stepBuilder.create();
                stepEntity = session.createEntity(stepEntity);
                if (this.configuration.isWriteDescriptionAndAttachments()) {
                    int attachmentCount = 0;
                    for (Attachment attachment : step.attachments) {
                        String fileName = "attachment_" + ++attachmentCount + "." + attachment.getFileExtension();
                        session.createAttachment(stepEntity, fileName, new ByteArrayInputStream(attachment.getFileData()));
                    }
                }
                addedStepNames.add(stepEntity.getStringFieldValue("name"));
            }
            Entity testInstanceUpdate = new TestInstanceBuilder().setStatus(testRun.getStringFieldValue("status")).setExecDateTimeFromEntity(testRun).create();
            session.updateEntity(testInstance.getId(), testInstanceUpdate);
            ec = session.queryEntities("run", "id[>" + testRunId + "]; test-id[" + data.hpAlmId + "]; cycle-id[" + testSetId + "]; name['Fast_Run_*']");
            if (ec.getTotalCount() > 0) {
                for (Entity e : ec) {
                    session.deleteEntity(e);
                }
            }
        }
    }

    private static class TestStepData {
        private RunStepBuilder runStepBuilder;
        private List<Attachment> attachments = new ArrayList<Attachment>();
        private StringBuilder sbDescription;

        private TestStepData() {
        }
    }

    private static class TestCaseData {
        private TestRunBuilder testRunBuilder;
        private DateTime startTime;
        private long hpAlmId;
        private Long hpAlmConfigId;
        private List<TestStepData> testSteps = new ArrayList<TestStepData>();
        boolean alreadyFailed = false;

        private TestCaseData() {
        }
    }
}

