/*
 * Decompiled with CFR 0.152.
 */
package org.aludratest.hpalm.service.impl;

import java.io.IOException;
import org.aludratest.config.ConfigProperties;
import org.aludratest.config.ConfigProperty;
import org.aludratest.config.Preferences;
import org.aludratest.exception.AccessFailure;
import org.aludratest.hpalm.impl.HpAlmConfiguration;
import org.aludratest.hpalm.infrastructure.HpAlmException;
import org.aludratest.hpalm.infrastructure.HpAlmSession;
import org.aludratest.hpalm.service.HpAlmCondition;
import org.aludratest.hpalm.service.HpAlmInteraction;
import org.aludratest.hpalm.service.HpAlmService;
import org.aludratest.hpalm.service.HpAlmVerification;
import org.aludratest.hpalm.service.impl.HpAlmInteractionImpl;
import org.aludratest.hpalm.service.impl.HpAlmVerificationCheckImpl;
import org.aludratest.service.AbstractConfigurableAludraService;
import org.codehaus.plexus.component.annotations.Requirement;

@ConfigProperties(value={@ConfigProperty(name="hpalmUrl", description="The URL to HP ALM. Must end with /qcbin, WITHOUT a terminating slash.", required=true, type=String.class), @ConfigProperty(name="userName", description="User name for HP ALM connections.", type=String.class, required=true), @ConfigProperty(name="password", description="Password for HP ALM user.", type=String.class, required=true), @ConfigProperty(name="domain", description="HP ALM Domain.", defaultValue="DEFAULT", type=String.class, required=true), @ConfigProperty(name="project", description="HP ALM Project to use.", type=String.class, required=true)})
public class HpAlmServiceImpl
extends AbstractConfigurableAludraService
implements HpAlmService {
    @Requirement
    private HpAlmConfiguration configuration;
    private HpAlmSession session;
    private HpAlmInteraction interaction;
    private HpAlmVerificationCheckImpl verificationCondition;

    public String getPropertiesBaseName() {
        return "hpalm";
    }

    public void configure(Preferences preferences) {
        this.configuration.configure(preferences);
    }

    public String getDescription() {
        return "Provides methods to interact with an HP ALM instance.";
    }

    @Override
    public HpAlmInteraction perform() {
        return this.interaction;
    }

    @Override
    public HpAlmVerification verify() {
        return this.verificationCondition;
    }

    @Override
    public HpAlmCondition check() {
        return this.verificationCondition;
    }

    public void close() {
        try {
            this.session.logout();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void initService() {
        try {
            this.session = HpAlmSession.create(this.configuration.getHpAlmUrl(), this.configuration.getDomain(), this.configuration.getProject(), this.configuration.getUserName(), this.configuration.getPassword());
            this.interaction = new HpAlmInteractionImpl(this.session);
            this.verificationCondition = new HpAlmVerificationCheckImpl(this.session);
        }
        catch (IOException e) {
            throw new AccessFailure("Could not connect to HP ALM", (Throwable)e);
        }
        catch (HpAlmException e) {
            throw new AccessFailure("Could not login to HP ALM", (Throwable)e);
        }
    }
}

