/*
 * Decompiled with CFR 0.152.
 */
package org.aludratest.hpalm.service.impl;

import java.io.IOException;
import java.util.List;
import org.aludratest.exception.AccessFailure;
import org.aludratest.exception.FunctionalFailure;
import org.aludratest.exception.TechnicalException;
import org.aludratest.hpalm.entity.Entity;
import org.aludratest.hpalm.infrastructure.EntityCollection;
import org.aludratest.hpalm.infrastructure.HpAlmException;
import org.aludratest.hpalm.infrastructure.HpAlmSession;
import org.aludratest.hpalm.infrastructure.HpAlmUtil;
import org.aludratest.hpalm.service.EntityType;
import org.aludratest.hpalm.service.HpAlmCondition;
import org.aludratest.hpalm.service.HpAlmVerification;
import org.aludratest.service.SystemConnector;
import org.aludratest.testcase.event.attachment.Attachment;
import org.databene.commons.Validator;

public class HpAlmVerificationCheckImpl
implements HpAlmVerification,
HpAlmCondition {
    private HpAlmSession session;

    public HpAlmVerificationCheckImpl(HpAlmSession session) {
        this.session = session;
    }

    @Override
    public void assertEntityFieldMatches(EntityType entityType, long id, String fieldName, Validator<String> validator) {
        try {
            EntityCollection ec = this.session.queryEntities(entityType.getHpAlmTypeName(), "id[" + HpAlmUtil.DF_ID.format(id) + "]");
            if (ec.getTotalCount() == 0) {
                throw new FunctionalFailure("Entity does not exist");
            }
            Entity e = (Entity)ec.iterator().next();
            String value = e.getStringFieldValue(fieldName);
            if (!validator.valid((Object)value)) {
                throw new FunctionalFailure("Value '" + value + " ' does not match Validator " + validator);
            }
        }
        catch (IOException e) {
            throw new AccessFailure("Could not query " + entityType.getHpAlmTypeName() + " #" + id, (Throwable)e);
        }
        catch (HpAlmException e) {
            throw new TechnicalException("Could not query " + entityType.getHpAlmTypeName() + " #" + id, (Throwable)e);
        }
    }

    @Override
    public void assertEntityExists(EntityType entityType, long id) {
        if (!this.entityExists(entityType, id)) {
            throw new FunctionalFailure("Entity does not exist");
        }
    }

    @Override
    public void assertEntityNotExists(EntityType entityType, long id) {
        if (this.entityExists(entityType, id)) {
            throw new FunctionalFailure("Entity exists, but expected non-existence");
        }
    }

    @Override
    public void assertAnyEntityExists(EntityType entityType, String query) {
        if (!this.anyEntityExists(entityType, query)) {
            throw new FunctionalFailure("No " + entityType.getHpAlmTypeName() + " matches query '" + query + "'");
        }
    }

    @Override
    public void assertNoEntityExists(EntityType entityType, String query) {
        if (this.anyEntityExists(entityType, query)) {
            throw new FunctionalFailure("At least one " + entityType.getHpAlmTypeName() + " matches query '" + query + "', which is unexpected");
        }
    }

    @Override
    public boolean anyEntityExists(EntityType entityType, String query) {
        try {
            EntityCollection ec = this.session.queryEntities(entityType.getHpAlmTypeName(), query);
            return ec.getTotalCount() > 0;
        }
        catch (IOException e) {
            throw new AccessFailure("Could not query " + entityType.getHpAlmTypeName(), (Throwable)e);
        }
        catch (HpAlmException e) {
            throw new TechnicalException("Could not query " + entityType.getHpAlmTypeName(), (Throwable)e);
        }
    }

    @Override
    public boolean entityExists(EntityType entityType, long id) {
        try {
            EntityCollection ec = this.session.queryEntities(entityType.getHpAlmTypeName(), "id[" + HpAlmUtil.DF_ID.format(id) + "]");
            return ec.getTotalCount() > 0;
        }
        catch (IOException e) {
            throw new AccessFailure("Could not query " + entityType.getHpAlmTypeName() + " #" + id, (Throwable)e);
        }
        catch (HpAlmException e) {
            throw new TechnicalException("Could not query " + entityType.getHpAlmTypeName() + " #" + id, (Throwable)e);
        }
    }

    public List<Attachment> createDebugAttachments() {
        return null;
    }

    public List<Attachment> createAttachments(Object object, String title) {
        return null;
    }

    public void setSystemConnector(SystemConnector systemConnector) {
    }
}

