/*
 * Decompiled with CFR 0.152.
 */
package org.aludratest.hpalm.util;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.aludratest.AludraTest;
import org.aludratest.hpalm.TestCaseIdResolver;
import org.aludratest.hpalm.entity.Entity;
import org.aludratest.hpalm.impl.HpAlmConfiguration;
import org.aludratest.hpalm.infrastructure.EntityCollection;
import org.aludratest.hpalm.infrastructure.HpAlmException;
import org.aludratest.hpalm.infrastructure.HpAlmSession;
import org.aludratest.hpalm.infrastructure.HpAlmUtil;
import org.aludratest.scheduler.RunnerTree;
import org.aludratest.scheduler.RunnerTreeBuilder;
import org.aludratest.scheduler.node.RunnerGroup;
import org.aludratest.scheduler.node.RunnerLeaf;
import org.aludratest.scheduler.node.RunnerNode;
import org.aludratest.service.AludraServiceManager;

public class HpAlmIdVerifier {
    private HpAlmSession session;
    private TestCaseIdResolver idResolver;
    private Set<Long> checkedTests = new HashSet<Long>();

    private HpAlmIdVerifier(HpAlmSession session, TestCaseIdResolver idResolver) {
        this.session = session;
        this.idResolver = idResolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Class<?> testClass;
        if (args.length != 1) {
            HpAlmIdVerifier.printUsage("Exactly one argument required.");
            System.exit(3);
            return;
        }
        String className = args[0];
        try {
            testClass = Class.forName(className);
        }
        catch (Exception e) {
            HpAlmIdVerifier.printUsage("Could not lookup test class " + className + " on classpath.");
            System.exit(1);
            return;
        }
        AludraTest framework = AludraTest.startFramework();
        try {
            AludraServiceManager serviceManager = framework.getServiceManager();
            RunnerTreeBuilder builder = (RunnerTreeBuilder)serviceManager.newImplementorInstance(RunnerTreeBuilder.class);
            System.out.println("Building execution tree for analysis, this can take a while...");
            RunnerTree runnerTree = builder.buildRunnerTree(testClass);
            HpAlmConfiguration configuration = (HpAlmConfiguration)serviceManager.newImplementorInstance(HpAlmConfiguration.class);
            TestCaseIdResolver idResolver = (TestCaseIdResolver)serviceManager.newImplementorInstance(TestCaseIdResolver.class);
            configuration.getHpAlmUrl();
            configuration.getDomain();
            configuration.getProject();
            configuration.getUserName();
            configuration.getPassword();
            HpAlmSession session = HpAlmSession.create(configuration.getHpAlmUrl(), configuration.getDomain(), configuration.getProject(), configuration.getUserName(), configuration.getPassword());
            HpAlmIdVerifier verifier = new HpAlmIdVerifier(session, idResolver);
            try {
                verifier.verify(runnerTree.getRoot());
            }
            finally {
                try {
                    session.logout();
                }
                catch (Exception e) {}
            }
        }
        finally {
            framework.stopFramework();
        }
    }

    private void verify(RunnerGroup group) throws IOException, HpAlmException {
        for (RunnerNode node : group.getChildren()) {
            if (node instanceof RunnerGroup) {
                this.verify((RunnerGroup)node);
                continue;
            }
            if (!(node instanceof RunnerLeaf)) continue;
            this.verify((RunnerLeaf)node);
        }
    }

    private void verify(RunnerLeaf leaf) throws IOException, HpAlmException {
        Long testId = this.idResolver.getHpAlmTestId(leaf);
        if (testId != null) {
            Long configId;
            try {
                this.session.getTest(testId);
            }
            catch (HpAlmException e) {
                System.err.println("Test ID not found in HP ALM: " + HpAlmUtil.DF_ID.format(testId));
                return;
            }
            if (!this.checkedTests.contains(testId)) {
                this.checkedTests.add(testId);
                EntityCollection configs = this.session.queryEntities("test-config", "parent-id[" + HpAlmUtil.DF_ID.format(testId) + "]");
                this.verifyHpAlmConfigsExistLocal(testId, leaf.getParent(), configs);
            }
            if ((configId = this.idResolver.getHpAlmTestConfigId(leaf)) != null) {
                EntityCollection configs = this.session.queryEntities("test-config", "id[" + HpAlmUtil.DF_ID.format(configId) + "]; parent-id[" + HpAlmUtil.DF_ID.format(testId) + "]");
                if (configs.getTotalCount() == 0) {
                    System.err.println("Local test configuration does not exist in HP ALM: " + HpAlmUtil.DF_ID.format(testId) + "/" + HpAlmUtil.DF_ID.format(configId));
                }
            } else {
                System.err.println("Local test configuration ID could not be determined for: " + leaf.getName());
            }
        }
    }

    private void verifyHpAlmConfigsExistLocal(Long testId, RunnerGroup group, EntityCollection configs) {
        HashSet<Long> notFoundIds = new HashSet<Long>();
        for (Entity config : configs) {
            notFoundIds.add(config.getId());
        }
        for (RunnerNode node : group.getChildren()) {
            if (!(node instanceof RunnerLeaf)) continue;
            notFoundIds.remove(this.idResolver.getHpAlmTestConfigId((RunnerLeaf)node));
        }
        for (Long id : notFoundIds) {
            System.err.println("HP ALM Test configuration ID has no local test configuration data: " + HpAlmUtil.DF_ID.format(testId) + "/" + HpAlmUtil.DF_ID.format(id));
        }
    }

    private static void printUsage(String errorMessage) {
        if (errorMessage != null) {
            System.err.println("ERROR: " + errorMessage);
            System.out.println();
        }
        System.out.println("HpAlmIdVerifier utility");
        System.out.println("=======================");
        System.out.println("Verifies for a given test or test suite class that all determined HP ALM IDs are valid.");
        System.out.println("Found configuration IDs must match their test IDs.");
        System.out.println("Non-matching or non-existing IDs are reported.");
        System.out.println();
        System.out.println("Usage:");
        System.out.println("java " + HpAlmIdVerifier.class.getName() + " <AludraTestSuiteClass>");
        System.out.println();
        System.out.println("AludraTestSuiteClass must be the fully qualified name of a class extending AludraTestCase");
        System.out.println("or being annotated with @Suite.");
        System.out.println("hpalm.properties must exist on classpath, according to AludraTest configuration guide.");
    }
}

