/*
 * Decompiled with CFR 0.152.
 */
package org.aludratest.hpalm.infrastructure;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBException;
import org.aludratest.hpalm.entity.Entity;
import org.aludratest.hpalm.entity.EntityResultSet;
import org.aludratest.hpalm.infrastructure.EntityCollection;
import org.aludratest.hpalm.infrastructure.EntityMarshallingUtils;
import org.aludratest.hpalm.infrastructure.HpAlmException;
import org.aludratest.hpalm.infrastructure.HpAlmUtil;
import org.aludratest.hpalm.infrastructure.PagedEntityCollectionImpl;
import org.aludratest.hpalm.infrastructure.QCRestException;
import org.aludratest.hpalm.infrastructure.Response;
import org.aludratest.hpalm.infrastructure.RestConnector;
import org.aludratest.hpalm.infrastructure.ServerTime;
import org.aludratest.hpalm.infrastructure.URLEncoder;
import org.apache.commons.io.IOUtils;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HpAlmSession {
    private RestConnector connector;
    private static final Logger LOG = LoggerFactory.getLogger(HpAlmSession.class);
    private static final String LWSSO_COOKIE_KEY = "LWSSO_COOKIE_KEY";
    private static final String QCESSION_COOKIE_KEY = "QCSession";
    private static final Map<String, String> JSON_ACCEPT_HEADER = new HashMap<String, String>();
    private static final Map<String, String> XML_ACCEPT_HEADER = new HashMap<String, String>();
    private static final Map<String, String> XML_POST_HEADERS = new HashMap<String, String>();
    private static final Map<String, String> FILE_POST_HEADERS = new HashMap<String, String>();
    private static final Pattern PATTERN_LWSSO_REALM = Pattern.compile("LWSSO realm=\"(http(s?)://[^\"]+)\"");

    private HpAlmSession(RestConnector connector) {
        this.connector = connector;
    }

    public static HpAlmSession create(String serverUrl, String domain, String project, String userName, String password) throws IOException, HpAlmException {
        RestConnector connector = new RestConnector(new HashMap<String, String>(), serverUrl, domain, project);
        Response response = connector.httpGet(connector.buildUrl("rest/is-authenticated"), null, XML_ACCEPT_HEADER);
        if (response.getStatusCode() != 401) {
            throw new HpAlmException("Unexpected HTTP status code during authentication: " + response.getStatusCode());
        }
        String authInfo = HpAlmSession.getSingleHeaderValue(response, "WWW-Authenticate");
        if (authInfo == null) {
            throw new HpAlmException("Server did not return authentication method information");
        }
        Matcher m = PATTERN_LWSSO_REALM.matcher(authInfo = authInfo.trim());
        if (!m.matches()) {
            throw new HpAlmException("Server returned unsupported authentication realm: " + authInfo);
        }
        String authUrl = m.group(1) + "/alm-authenticate";
        StringWriter sw = new StringWriter();
        PrettyPrintXMLWriter writer = new PrettyPrintXMLWriter((Writer)sw);
        writer.startElement("alm-authentication");
        writer.startElement("user");
        writer.writeText(userName);
        writer.endElement();
        writer.startElement("password");
        writer.writeText(password);
        writer.endElement();
        writer.endElement();
        response = connector.httpPost(authUrl, sw.toString().getBytes("UTF-8"), XML_POST_HEADERS);
        if (response.getStatusCode() == 401) {
            throw new HpAlmException("Invalid user name or password");
        }
        String cookie = HpAlmSession.getCookie(response, LWSSO_COOKIE_KEY);
        if (cookie == null) {
            throw new HpAlmException("Login response did not contain required session cookie");
        }
        connector.getCookies().put(LWSSO_COOKIE_KEY, cookie);
        sw = new StringWriter();
        writer = new PrettyPrintXMLWriter((Writer)sw);
        writer.startElement("session-parameters");
        writer.startElement("time-out");
        writer.writeText("5");
        writer.endElement();
        writer.endElement();
        response = connector.httpPost(connector.buildUrl("rest/site-session"), sw.toString().getBytes("UTF-8"), XML_POST_HEADERS);
        if (response.getStatusCode() != 200) {
            throw new HpAlmException("Could not start HP ALM Session for user " + userName);
        }
        cookie = HpAlmSession.getCookie(response, QCESSION_COOKIE_KEY);
        if (cookie == null) {
            throw new HpAlmException("Server did not send a session cookie");
        }
        connector.getCookies().put(QCESSION_COOKIE_KEY, cookie);
        return new HpAlmSession(connector);
    }

    public void extendTimeout() throws IOException {
        this.connector.httpGet(this.connector.buildUrl("rest/site-session"), null, XML_ACCEPT_HEADER);
    }

    public void logout() throws IOException {
        this.connector.httpGet(this.connector.buildUrl("authentication-point/logout"), null, XML_ACCEPT_HEADER);
    }

    public String getFieldsXml(String entityType, boolean required) throws IOException {
        Response response = this.connector.httpGet(this.connector.buildUrl("rest/domains/DEFAULT/projects/Training_and_Test/customization/entities/" + entityType + "/fields"), "required=" + required, XML_ACCEPT_HEADER);
        return new String(response.getResponseData(), "UTF-8");
    }

    public ServerTime getServerTime() throws IOException, HpAlmException {
        Response response = this.connector.httpGet(this.connector.buildUrl("rest/server/time"), null, XML_ACCEPT_HEADER);
        if (response.getStatusCode() != 200) {
            this.raiseHpAlmException(response);
        }
        String xml = new String(response.getResponseData(), "UTF-8");
        try {
            return EntityMarshallingUtils.marshal(ServerTime.class, xml);
        }
        catch (JAXBException e) {
            throw new IOException("Could not unmarshal Server Time", e);
        }
    }

    public TimeZone determineServerTimeZone() throws IOException, HpAlmException {
        long compare;
        ServerTime serverTime = this.getServerTime();
        long millis = Long.parseLong(serverTime.getTimeInMillis());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        try {
            compare = sdf.parse(serverTime.getDateTime()).getTime();
        }
        catch (ParseException pe) {
            throw new HpAlmException("HP ALM returned unparseable datetime string: " + serverTime.getDateTime());
        }
        long diff = compare - millis;
        int diffHours = (int)Math.round((double)diff / 3600000.0);
        int diffMinutes = (int)Math.abs(Math.round((double)(diff - (long)diffHours * 1000L * 60L * 60L) / 60000.0));
        String determinedTimeZone = "" + diffMinutes;
        if (determinedTimeZone.length() == 1) {
            determinedTimeZone = "0" + determinedTimeZone;
        }
        determinedTimeZone = "GMT" + (diffHours < 0 ? "" : "+") + diffHours + ":" + determinedTimeZone;
        return TimeZone.getTimeZone(determinedTimeZone);
    }

    public Entity createEntity(Entity entity) throws IOException, HpAlmException {
        LOG.debug("Creating entity of type " + entity.getType() + " with name " + entity.getStringFieldValue("name"));
        try {
            Response response;
            String xml = EntityMarshallingUtils.unmarshal(Entity.class, entity);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Full creation XML: " + xml);
            }
            if ((response = this.connector.httpPost(this.connector.buildEntityCollectionUrl(entity.getType()), xml.getBytes("UTF-8"), XML_POST_HEADERS)).getStatusCode() != 201) {
                this.raiseHpAlmException(response);
            }
            xml = new String(response.getResponseData(), "UTF-8");
            Entity result = EntityMarshallingUtils.marshal(Entity.class, xml);
            LOG.debug("Created entity got ID " + result.getId());
            return result;
        }
        catch (JAXBException e) {
            throw new IOException("Could not unmarshal Entity", e);
        }
    }

    public Entity updateEntity(long id, Entity updateValues) throws IOException, HpAlmException {
        LOG.debug("Updating entity of type " + updateValues.getType() + " with ID " + id);
        try {
            Response response;
            String xml = EntityMarshallingUtils.unmarshal(Entity.class, updateValues);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Full update XML: " + xml);
            }
            if ((response = this.connector.httpPut(this.connector.buildEntityCollectionUrl(updateValues.getType()) + "/" + id, xml.getBytes("UTF-8"), XML_POST_HEADERS)).getStatusCode() != 200) {
                this.raiseHpAlmException(response);
            }
            xml = new String(response.getResponseData(), "UTF-8");
            return EntityMarshallingUtils.marshal(Entity.class, xml);
        }
        catch (JAXBException e) {
            throw new IOException("Could not unmarshal Entity", e);
        }
    }

    public void deleteEntity(String entityType, long id) throws IOException, HpAlmException {
        Response response = this.connector.httpDelete(this.connector.buildEntityCollectionUrl(entityType) + "/" + id, XML_ACCEPT_HEADER);
        if (response.getStatusCode() != 200) {
            this.raiseHpAlmException(response);
        }
    }

    public void deleteEntity(Entity entity) throws IOException, HpAlmException {
        this.deleteEntity(entity.getType(), entity.getId());
    }

    public Entity createAttachment(Entity entity, String fileName, InputStream attachmentData) throws IOException, HpAlmException {
        LinkedHashMap<String, String> headerMap = new LinkedHashMap<String, String>(FILE_POST_HEADERS);
        headerMap.put("Slug", fileName);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)attachmentData, (OutputStream)baos);
        byte[] data = baos.toByteArray();
        String url = this.connector.buildEntityCollectionUrl(entity.getType());
        url = url + "/" + entity.getId() + "/attachments";
        Response response = this.connector.httpPost(url, data, headerMap);
        if (response.getStatusCode() != 201) {
            this.raiseHpAlmException(response);
        }
        String xml = new String(response.getResponseData(), "UTF-8");
        try {
            return EntityMarshallingUtils.marshal(Entity.class, xml);
        }
        catch (JAXBException e) {
            throw new HpAlmException("Invalid XML received after attachment creation", e);
        }
    }

    public EntityCollection getTestRuns() throws IOException, HpAlmException {
        return this.getEntityCollection("run", "test runs");
    }

    public EntityCollection getTests() throws IOException, HpAlmException {
        return this.getEntityCollection("test", "tests");
    }

    public EntityCollection getTestSets() throws IOException, HpAlmException {
        return this.getEntityCollection("test-set", "test sets");
    }

    public EntityCollection getTestFolders() throws IOException, HpAlmException {
        return this.getEntityCollection("test-folder", "test folders");
    }

    public EntityCollection getTestSetFolders() throws IOException, HpAlmException {
        return this.getEntityCollection("test-set-folder", "test set folders");
    }

    public Entity getTest(long id) throws IOException, HpAlmException {
        return this.getEntity("test", id);
    }

    public Entity getTestSet(long id) throws IOException, HpAlmException {
        return this.getEntity("test-set", id);
    }

    public Entity getTestFolder(long id) throws IOException, HpAlmException {
        return this.getEntity("test-folder", id);
    }

    public Entity getTestSetFolder(long id) throws IOException, HpAlmException {
        return this.getEntity("test-set-folder", id);
    }

    public EntityCollection queryEntities(String entityName, String query) throws IOException, HpAlmException {
        if (query != null) {
            query = HpAlmSession.encodeQuery(query);
        }
        String url = this.connector.buildEntityCollectionUrl(entityName) + (query != null ? "?query={" + query + "}" : "");
        return new PagedEntityCollectionImpl(this, url, this.doGet(url));
    }

    public EntityCollection getAssetRelations(Entity entity) throws IOException, HpAlmException {
        String url = this.connector.buildEntityCollectionUrl(entity.getType()) + "/" + HpAlmUtil.DF_ID.format(entity.getId()) + "/asset-relations";
        return new PagedEntityCollectionImpl(this, url, this.doGet(url));
    }

    EntityResultSet doGet(String url) throws IOException, HpAlmException {
        Response response = this.connector.httpGet(url, null, XML_ACCEPT_HEADER);
        if (response.getStatusCode() != 200) {
            this.raiseHpAlmException(response);
        }
        try {
            String xml = new String(response.getResponseData(), "UTF-8");
            return EntityMarshallingUtils.marshal(EntityResultSet.class, xml);
        }
        catch (JAXBException e) {
            throw new HpAlmException("Invalid XML format returned by HP ALM", e);
        }
    }

    private void raiseHpAlmException(Response response) throws HpAlmException {
        try {
            if (response.getResponseData() != null && response.getResponseData().length > 0) {
                String xml = new String(response.getResponseData(), "UTF-8");
                QCRestException qcex = EntityMarshallingUtils.marshal(QCRestException.class, xml);
                if (qcex.getTitle() != null && qcex.getId() != null) {
                    throw new HpAlmException(qcex.getTitle(), qcex.getId());
                }
                if (qcex.getTitle() != null) {
                    throw new HpAlmException(qcex.getTitle());
                }
                if (qcex.getId() != null) {
                    throw new HpAlmException(qcex.getId());
                }
            }
        }
        catch (JAXBException e) {
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("No UTF-8 available here. Cannot continue.");
        }
        throw new HpAlmException("Unexpected HP ALM status code, no further information: " + response.getStatusCode());
    }

    public Entity getEntity(String entityName, long id) throws IOException, HpAlmException {
        Response response = this.connector.httpGet(this.connector.buildEntityCollectionUrl(entityName) + "/" + HpAlmUtil.DF_ID.format(id), null, XML_ACCEPT_HEADER);
        if (response.getStatusCode() != 200) {
            this.raiseHpAlmException(response);
        }
        try {
            String xml = new String(response.getResponseData(), "UTF-8");
            return EntityMarshallingUtils.marshal(Entity.class, xml);
        }
        catch (JAXBException e) {
            throw new HpAlmException("Invalid XML format in " + entityName, e);
        }
    }

    private EntityCollection getEntityCollection(String entityName, String entitiesDisplayName) throws IOException, HpAlmException {
        String url = this.connector.buildEntityCollectionUrl(entityName);
        EntityResultSet resultSet = this.doGet(url);
        return new PagedEntityCollectionImpl(this, url, resultSet);
    }

    private static String getSingleHeaderValue(Response response, String header) {
        Iterator<String> iter;
        Iterable<String> values;
        Map<String, ? extends Iterable<String>> headers = response.getResponseHeaders();
        if (headers != null && (values = headers.get(header)) != null && (iter = values.iterator()).hasNext()) {
            return iter.next();
        }
        return null;
    }

    private static String getCookie(Response response, String key) {
        Iterable<String> values;
        Map<String, ? extends Iterable<String>> headers = response.getResponseHeaders();
        if (headers != null && (values = headers.get("Set-Cookie")) != null) {
            for (String cookie : values) {
                String k;
                if ((cookie = cookie.trim()).contains(";")) {
                    cookie = cookie.substring(0, cookie.indexOf(59)).trim();
                }
                if (!cookie.contains("=") || !key.equals(k = cookie.substring(0, cookie.indexOf(61)).trim())) continue;
                return cookie.substring(cookie.indexOf(61) + 1).trim();
            }
        }
        return null;
    }

    private static String encodeQuery(String query) {
        return new URLEncoder().encode(query);
    }

    static {
        JSON_ACCEPT_HEADER.put("Accept", "application/json");
        XML_ACCEPT_HEADER.put("Accept", "application/xml");
        XML_POST_HEADERS.putAll(XML_ACCEPT_HEADER);
        XML_POST_HEADERS.put("Content-Type", "application/xml");
        FILE_POST_HEADERS.putAll(XML_ACCEPT_HEADER);
        FILE_POST_HEADERS.put("Content-Type", "application/octet-stream");
    }
}

