/*
 * Decompiled with CFR 0.152.
 */
package org.aludratest.hpalm.infrastructure;

import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import org.aludratest.hpalm.entity.Entity;
import org.aludratest.hpalm.entity.TestInstanceBuilder;
import org.aludratest.hpalm.entity.TestSetBuilder;
import org.aludratest.hpalm.entity.TestSetFolderBuilder;
import org.aludratest.hpalm.infrastructure.EntityCollection;
import org.aludratest.hpalm.infrastructure.HpAlmException;
import org.aludratest.hpalm.infrastructure.HpAlmSession;

public final class HpAlmUtil {
    public static final DecimalFormat DF_ID = (DecimalFormat)NumberFormat.getInstance(Locale.US);

    private HpAlmUtil() {
    }

    public static Entity createTestSetFolderPath(HpAlmSession session, String path) throws IOException, HpAlmException {
        if (path == null) {
            throw new IllegalArgumentException("Path is null");
        }
        String[] pathSegments = path.split("/");
        if (pathSegments.length == 0) {
            throw new IllegalArgumentException("Path is empty.");
        }
        for (String f : pathSegments) {
            if (f.length() != 0) continue;
            throw new IllegalArgumentException("Path is invalid. Path must not begin or end with a slash, and not contain double slashes.");
        }
        String query = "name['" + pathSegments[0] + "']";
        EntityCollection rootFolders = session.queryEntities("test-set-folder", query);
        if (rootFolders.getTotalCount() != 1) {
            throw new HpAlmException("Found no or more than one root folder matching first segment " + pathSegments[0]);
        }
        Entity result = (Entity)rootFolders.iterator().next();
        for (int i = 1; i < pathSegments.length; ++i) {
            query = "name['" + pathSegments[i] + "']; parent-id[" + result.getId() + "]";
            EntityCollection folders = session.queryEntities("test-set-folder", query);
            if (folders.getTotalCount() > 1) {
                throw new HpAlmException("Found more than one folder matching segment " + pathSegments[i]);
            }
            if (folders.getTotalCount() == 0) {
                TestSetFolderBuilder builder = new TestSetFolderBuilder();
                Entity e = builder.setParentId(result.getId()).setName(pathSegments[i]).create();
                result = session.createEntity(e);
                continue;
            }
            result = (Entity)folders.iterator().next();
        }
        return result;
    }

    public static Entity createOrGetTestSet(HpAlmSession session, long testSetFolderId, String testSetName) throws IOException, HpAlmException {
        EntityCollection testSets = session.queryEntities("test-set", "parent-id[" + DF_ID.format(testSetFolderId) + "]; name['" + testSetName + "']");
        if (testSets.getTotalCount() == 0) {
            Entity testSet = new TestSetBuilder().setParentId(testSetFolderId).setName(testSetName).create();
            return session.createEntity(testSet);
        }
        return (Entity)testSets.iterator().next();
    }

    public static Entity createOrGetTestInstance(HpAlmSession session, long testSetId, long testId, Long testConfigId) throws IOException, HpAlmException {
        return HpAlmUtil.createOrGetTestInstance(session, testSetId, testId, testConfigId, true);
    }

    private static Entity createOrGetTestInstance(HpAlmSession session, long testSetId, long testId, Long testConfigId, boolean createIfNotFound) throws IOException, HpAlmException {
        EntityCollection testInstances = session.queryEntities("test-instance", "cycle-id[" + DF_ID.format(testSetId) + "]; test-id[" + DF_ID.format(testId) + "]" + (testConfigId != null ? "; test-config-id[" + DF_ID.format(testConfigId) + "]" : ""));
        if (testInstances.getTotalCount() == 0 && createIfNotFound) {
            testInstances = session.queryEntities("test-instance", "cycle-id[" + DF_ID.format(testSetId) + "]");
            long maxOrderNo = 0L;
            for (Entity e : testInstances) {
                maxOrderNo = Math.max(e.getLongFieldValue("test-order"), maxOrderNo);
            }
            TestInstanceBuilder builder = new TestInstanceBuilder().setTestSetId(testSetId).setTestId(testId).setOrderNumber(maxOrderNo + 1L);
            if (testConfigId != null) {
                builder.setTestConfigId(testConfigId);
            }
            Entity testInstance = builder.create();
            testInstance = session.createEntity(testInstance);
            return HpAlmUtil.createOrGetTestInstance(session, testSetId, testId, testConfigId, false);
        }
        return testInstances.getTotalCount() == 0 ? null : (Entity)testInstances.iterator().next();
    }

    static {
        DF_ID.setGroupingUsed(false);
        DF_ID.setMaximumFractionDigits(0);
        DF_ID.setDecimalSeparatorAlwaysShown(false);
    }
}

