/*
 * Decompiled with CFR 0.152.
 */
package org.aludratest.hpalm.infrastructure;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.aludratest.hpalm.infrastructure.Response;

public class RestConnector {
    protected Map<String, String> cookies;
    protected String serverUrl;
    protected String domain;
    protected String project;

    public RestConnector(Map<String, String> cookies, String serverUrl, String domain, String project) {
        this.cookies = cookies;
        this.serverUrl = serverUrl;
        this.domain = domain;
        this.project = project;
    }

    public String buildEntityCollectionUrl(String entityType) {
        return this.buildUrl("rest/domains/" + this.domain + "/projects/" + this.project + "/" + entityType + "s");
    }

    public String buildUrl(String path) {
        return String.format("%1$s/%2$s", this.serverUrl, path);
    }

    public Map<String, String> getCookies() {
        return this.cookies;
    }

    public void setCookies(Map<String, String> cookies) {
        this.cookies = cookies;
    }

    public Response httpPut(String url, byte[] data, Map<String, String> headers) throws IOException {
        return this.doHttp("PUT", url, null, data, headers, this.cookies);
    }

    public Response httpPost(String url, byte[] data, Map<String, String> headers) throws IOException {
        return this.doHttp("POST", url, null, data, headers, this.cookies);
    }

    public Response httpDelete(String url, Map<String, String> headers) throws IOException {
        return this.doHttp("DELETE", url, null, null, headers, this.cookies);
    }

    public Response httpGet(String url, String queryString, Map<String, String> headers) throws IOException {
        return this.doHttp("GET", url, queryString, null, headers, this.cookies);
    }

    private Response doHttp(String type, String url, String queryString, byte[] data, Map<String, String> headers, Map<String, String> cookies) throws IOException {
        headers = new HashMap<String, String>(headers);
        if (queryString != null && !queryString.isEmpty()) {
            url = url + "?" + queryString;
        }
        HttpURLConnection con = (HttpURLConnection)new URL(url).openConnection();
        con.setRequestMethod(type);
        String cookieString = this.getCookieString();
        this.prepareHttpRequest(con, headers, data, cookieString);
        con.connect();
        Response ret = this.retrieveHtmlResponse(con);
        this.updateCookies(ret);
        return ret;
    }

    private void prepareHttpRequest(HttpURLConnection con, Map<String, String> headers, byte[] bytes, String cookieString) throws IOException {
        String contentType = null;
        if (cookieString != null && !cookieString.isEmpty()) {
            con.setRequestProperty("Cookie", cookieString);
        }
        if (headers != null) {
            contentType = headers.remove("Content-Type");
            for (Map.Entry<String, String> header : headers.entrySet()) {
                con.setRequestProperty(header.getKey(), header.getValue());
            }
        }
        if (bytes != null && bytes.length > 0) {
            con.setDoOutput(true);
            if (contentType != null) {
                con.setRequestProperty("Content-Type", contentType);
            }
            OutputStream out = con.getOutputStream();
            out.write(bytes);
            out.flush();
            out.close();
        }
    }

    private Response retrieveHtmlResponse(HttpURLConnection con) throws IOException {
        int read;
        InputStream inputStream;
        Response ret = new Response();
        ret.setStatusCode(con.getResponseCode());
        ret.setResponseHeaders(con.getHeaderFields());
        try {
            inputStream = con.getInputStream();
        }
        catch (IOException e) {
            inputStream = con.getErrorStream();
            ret.setFailure(e);
        }
        ByteArrayOutputStream container = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        while (inputStream != null && (read = inputStream.read(buf, 0, 1024)) > 0) {
            container.write(buf, 0, read);
        }
        ret.setResponseData(container.toByteArray());
        return ret;
    }

    private void updateCookies(Response response) {
        Iterable<String> newCookies = response.getResponseHeaders().get("Set-Cookie");
        if (newCookies != null) {
            for (String cookie : newCookies) {
                int equalIndex = cookie.indexOf(61);
                int semicolonIndex = cookie.indexOf(59);
                String cookieKey = cookie.substring(0, equalIndex);
                String cookieValue = cookie.substring(equalIndex + 1, semicolonIndex);
                this.cookies.put(cookieKey, cookieValue);
            }
        }
    }

    public String getCookieString() {
        StringBuilder sb = new StringBuilder();
        if (!this.cookies.isEmpty()) {
            Set<Map.Entry<String, String>> cookieEntries = this.cookies.entrySet();
            for (Map.Entry<String, String> entry : cookieEntries) {
                sb.append(entry.getKey()).append("=").append(entry.getValue()).append(";");
            }
        }
        String ret = sb.toString();
        return ret;
    }
}

